% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_graph_info.R
\name{get_graph_info}
\alias{get_graph_info}
\title{Retrieve Information Tables about a Specific Graph from the SuiteSparse Matrix Collection.}
\usage{
get_graph_info(matrixname, groupname)
}
\arguments{
\item{matrixname}{Name of the matrix/graph for which to fetch information.}

\item{groupname}{Name of the group that provides the matrix/graph.}
}
\value{
A list of tables with detailed information about the specified matrix/graph:
\itemize{
  \item "Matrix Information"
  \item "Matrix Properties"
  \item "SVD Statistics" (if available)
}
}
\description{
\code{get_graph_info} fetches the overview tables about a specified graph/matrix from the SuiteSparse Matrix Collection.
}
\details{
The tables contain detailed information and properties about the graph/matrix, such as its size, number of non-zero elements, etc. Visit \url{https://sparse.tamu.edu/} to explore groups and matrix names.
}
\note{
The \code{rvest} package is used for parsing HTML, if it is not installed, the function will prompt for installation.
}
\examples{
\dontrun{
matrixname <- "grid1"
groupname <- "AG-Monien"
info_tables <- get_graph_info(matrixname,groupname)

# Matrix Information
info_tables[[1]]

# Matrix Properties
info_tables[[2]]

# SVD Statistics
info_tables[[3]]
}
#' @seealso \code{\link{download_graph}}
}
\references{
Davis, T. A., & Hu, Y. (2011). The University of Florida sparse matrix collection. ACM Transactions on Mathematical Software (TOMS), 38(1), 1-25.

Kolodziej, S. P., Aznaveh, M., Bullock, M., David, J., Davis, T. A., Henderson, M.,
Hu, Y., & Sandstrom, R. (2019). The suitesparse matrix collection website interface. Journal of Open Source Software, 4(35), 1244.
}
