% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpval.R
\name{fpval}
\alias{fpval}
\title{ Calculates the regression coefficients, the P-values and the standard P-values for the chosen subset ind}
\usage{
fpval(y,x,ind,q,xinr=F)
}
\arguments{
\item{y}{The dependent variable}

\item{x}{The covariates}

\item{ind}{The subset of the covariates x for which the P-values are required}

\item{q}{The total number of covariates from which ind was chosen}

\item{xinr}{If TRUE intercept included}

}
\value{
apv In order the subset ind, the regression coefficients, the P-values, the standard P-values.

res The residuals
}
\description{
Calculates the regression coefficients, the P-values and the standard P-values for the chosen subset ind.
}
\examples{
data(boston)
a<-fpval(boston[,14],boston[,1:13],c(1,2,4:6,8:13),13)
}
