% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{first_below}
\alias{first_below}
\title{Find the first point when a numeric vector falls below some threshold}
\usage{
first_below(
  y,
  x = NULL,
  threshold,
  return = "index",
  return_endpoints = TRUE,
  subset = NULL,
  na.rm = TRUE,
  ...
)
}
\arguments{
\item{y}{Numeric vector of y values in which to identify first below point}

\item{x}{Optional numeric vector of corresponding x values}

\item{threshold}{Threshold y value of interest}

\item{return}{One of \code{c("index", "x")}, determining whether the function
will return the \code{index} or \code{x} value associated with 
the first-below point.

If \code{index}, it will refer to the first data point
below the threshold.

If \code{x}, it will use linear interpolation and the data
points immediately before and after the threshold-crossing
to return the exact \code{x} value when \code{y} first
came below \code{threshold}}

\item{return_endpoints}{Boolean for whether startpoint should be returned
when the startpoint is below \code{threshold}}

\item{subset}{A vector of Boolean values indicating which x and y values
should be included (TRUE) or excluded (FALSE).

If \code{return = "index"}, index will be for the whole 
vector and not the subset of the vector}

\item{na.rm}{Boolean whether NA's should be removed before analyzing.
If \code{return = 'index'}, indices will refer to the original
\code{y} vector *including* \code{NA} values}

\item{...}{Other arguments to pass to \code{find_threshold_crosses}}
}
\value{
A vector of indices (\code{return = "index"}) or x values
        (\code{return = "x"}) for when \code{y} crossed \code{threshold}
}
\description{
This function takes a vector of \code{y} values and 
returns the index (by default) of the first point that falls
below some threshold y value. This function is essentially a wrapper for 
\code{find_threshold_crosses(return_rising = FALSE, return_falling = TRUE)[1]}
}
\details{
This function is designed to be compatible for use within
 dplyr::group_by and dplyr::summarize
}
