% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reference_funcs.R
\name{gdl_levels}
\alias{gdl_levels}
\title{Get level list}
\usage{
gdl_levels(session)
}
\arguments{
\item{session}{A valid GDL session object to interface with.}
}
\value{
A data frame containing a list of levels for the dataset.
}
\description{
Returns a list of data levels available in the current dataset.
}
\examples{
\dontrun{
# Create a session using your API token (provided by environment here)
session <- gdl_session(Sys.getenv('GDL_API_TOKEN'))
# Request list of available levels
levels <- gdl_levels(session)
head(levels, n=10)
}
}
