\name{smoking}
\alias{smoking}
\docType{data}
\title{A Smoking Cessation Data}
\description{
The original data consist of 223 people enrolled in the study between November 1986
and February 1989 from 51 zip codes in the southeastern corner of Minnesota in the
United States (Banerjee and Carlin, 2004). In this study, smokers were randomly assigned 
to one of two treatment groups: smoking intervention (SI) group or usual care (UC) group. 
The survival time is defined as the time (in years) required for a failed quitter to 
resume smoking. The people residing in the area with the same zip code form a cluster 
and may be spatially correlated due to the shared environment.}
\usage{data(smoking)}
\format{
Observed covariates include
  \describe{
    \item{\code{SexF}}{0 = male, 1 = female.}
    \item{\code{Duration}}{duration as smoker in years.}
    \item{\code{SI.UC}}{intervention type: 1 = smoking intervention (SI), 0 = usual care (UC).}
    \item{\code{F10Cigs}}{the average number of cigarettes smoked per day over the last 10 years (rounded).}
    \item{\code{Relapse}}{1 = relapse, 0 = no relapse.}
    \item{\code{Timept1}}{the time of study entry.}
    \item{\code{Timept2}}{the time of resume smoking.}
    \item{\code{Zip}}{51 zip codes in the southeastern corner of Minnesota.}
  }
}
\references{
Banerjee, S. and Carlin,  B. P. (2004) Parametric spatial cure rate models for interval-censored
time-to-relapse data. \emph{Biometrics}, \bold{60}: 268-275.
}
\keyword{datasets}