% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gelnet.R
\name{L1.ceiling}
\alias{L1.ceiling}
\title{The largest meaningful value of the L1 parameter}
\usage{
L1.ceiling(X, y, a = rep(1, nrow(X)), d = rep(1, ncol(X)))
}
\arguments{
\item{X}{n-by-p matrix of n samples in p dimensions}

\item{y}{n-by-1 response vector}

\item{a}{n-by-1 vector of sample weights}

\item{d}{p-by-1 vector of feature weights}
}
\value{
The largest meaningful value of the L1 parameter (i.e., the smallest value that yields a model with all zero weights)
}
\description{
Computes the smallest value of the LASSO coefficient L1 that leads to an
 all-zero weight vector for a given linear regression problem.
}
\details{
The cyclic coordinate descent updates the model weight \eqn{w_k} using a soft threshold operator
\eqn{ S( \cdot, \lambda_1 d_k ) } that clips the value of the weight to zero, whenever the absolute
value of the first argument falls below \eqn{\lambda_1 d_k}. From here, it is straightforward to compute
the smallest value of \eqn{\lambda_1}, such that all weights are clipped to zero.
}

