% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{ggplotDistanceGraph_EC}
\alias{ggplotDistanceGraph_EC}
\title{Plotting a Distance Network (error correction)}
\usage{
ggplotDistanceGraph_EC(
  BC_dat,
  BC_dat_EC,
  minDist = 1,
  loga = TRUE,
  equal_node_sizes = TRUE,
  BC_threshold = NULL,
  ori_BCs = NULL,
  lay = "fruchtermanreingold",
  complete = FALSE,
  col_type = "rainbow",
  m = "hamming",
  scale_nodes = 1,
  scale_edges = 1
)
}
\arguments{
\item{BC_dat}{a BCdat object.}

\item{BC_dat_EC}{the error corrected BCdat object (the EC_analysis parameter needs to be set to TRUE).}

\item{minDist}{an integer value representing the maximal distance for which the graph will
contain edges.}

\item{loga}{a logical value, indicating the use or non-use of logarithmic read count values.}

\item{equal_node_sizes}{a logical value. If TRUE, every node will have the same size.}

\item{BC_threshold}{a nnumeric value, limiting the number of barcodes for which their error correction "history" will be colored (if BC_threshold = 5 then the five biggest barcodes will be evaluated)}

\item{ori_BCs}{a vector of character strings containing barcode sequences (without the fixed positions of the barcode construct). Similar to BC_threshold but allowing for barcode identification via sequence.}

\item{lay}{a character string, identifying the prefered layout algorithm (see ggnetwork layout option).}

\item{complete}{a logical value. If TRUE, every node will have at least one edge.}

\item{col_type}{a character sting, choosing one of the available color palettes.}

\item{m}{a character string, Method for distance calculation, default value is Hamming distance. Possible values
are "osa", "lv", "dl", "hamming", "lcs", "qgram", "cosine", "jaccard", "jw", "soundex" (see stringdist function
of the stringdist-package for more information).}

\item{scale_nodes}{a numeric value, scaling the node size.}

\item{scale_edges}{a numeric value, scaling the edge size.}
}
\value{
a ggplot2 object
}
\description{
ggplotDistanceGraph will create a graph-like visualisation (ripple plot) of the corresponding barcode sequences
and their similarity based on the ggplot2 and the ggnetwork packages. The nodes represent the barcode sequences and their
respective size reflects the corresponding read counts. Edges between nodes indicate a distance between two barcodes
of maximal \code{minDist}.
If \code{ori_BCs} is provided the node color also refelects the distance of a particular barcode to one of the initial
barcodes.
}
