% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-fitNN.R
\name{fitNN}
\alias{fitNN}
\title{Helpful mini function to fit the nearest neighbor (NN) algorithm given a set and
defined distance}
\usage{
fitNN(uniqueDraws, uniqueLabels, distance, minDist)
}
\arguments{
\item{uniqueDraws}{List of unique values that make up the set on which we are using
the NN algorithm}

\item{uniqueLabels}{List of unique labels associated 1-1 with the unique values}

\item{distance}{Function with arguments x,y that returns a distance
defined on the given values}

\item{minDist}{Minimum possible distance between two points that aren't equivalent.
May be ignored, but if possible to specify, may speed up the algorithm.}
}
\value{
List. tsSolution gives the ordered labels, tsValues gives the ordered values,
tsDiffs is a vector of distances between consecutive values in tsValues
}
\description{
Helpful mini function to fit the nearest neighbor (NN) algorithm given a set and
defined distance
}
