\name{searchResultsSummaryTable}
\alias{searchResultsSummaryTable}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Build a data frame populated with the results of a sequential searching
of signatures starting from a list of seed-genes.
}

\description{The data frame contains as many rows as the list of seed-genes and six columns as described in the value section.}
\usage{searchResultsSummaryTable(aSearchResults)}
\arguments{\item{aSearchResults}{is a list of the signatures computed from a list of seed-genes. See the example.}
}
%%\details{
%%  ~~ If necessary, more details than the description above ~~
%%}
\value{A data frame with the following columns
%%  ~Describe the value returned
%%  If it is a LIST, use
  \item{column no.1}{starting/seed-gene.}
  \item{column no.2}{number of genes in the signature.}
  \item{column no.3}{test value of the log-rank test for the survival curves associated to the good and poor prognosis groups.}
  \item{column no.4}{log(p-value)/log(10), the p-value is the one corresponding to the test value of the log-rank test.}
  \item{column no.5}{ratio of the test values of the log-rank test computed with
respect to the clustering given by the starting gene and the clustering
generated by the signature}
  \item{column no.6}{genes in the signature}
}
%%\references{
%% ~put references to the literature/web site here ~
%%}
\author{Stefano M. Pagnotta and Michele Ceccarelli}
\note{The ratio of the test values in column no.5 measures the improvement of
the separation of the survival curves when the classification is based on the
signature instead of the starting gene.}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{\code{\link{help}}.}
\examples{
data(geNSCLC)
geData <- geNSCLC
data(stNSCLC)
stData <- stNSCLC

# CALCA = 152, SELP = 115
seedGenes <- c(152, 115)
K <- length(seedGenes)
searchResults <- vector("list", K)
names(searchResults) <- colnames(geData)[seedGenes]

for(k in 1:K) 
      searchResults[[k]] <- signatureFinder(seedGenes[k]) 
print(searchResults)
signaturesTable <- searchResultsSummaryTable(searchResults)
print(signaturesTable)
# save the table in the XLS format, uncomment the following lines.
#library("WriteXLS")
#WriteXLS("signaturesTable", row.names = TRUE, "SearchResultsSummaryTable.xls")
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{ ~kwd1 }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
