#'Clones from the PLRV population
#'
#'@description  resistance study to PLRV (Patato Leaf Roll Virus) causing leaf
#'curl. 28 genotypes were experimented at 6 locations in Peru. Each clone was
#'evaluated three times in each environment, and yield, plant weight and plot were
#'registered.
#'
#'@name plrv
#'@docType data
#'@usage data(plrv)
#'
#'@format Data frame with 504 observations and 6 variables (genotype,
#'   locality, repetition, weightPlant, weightPlot and yield).
#'
#'@keywords datasets
#'
#'@references Felipe de Mendiburu (2020). agricolae: Statistical Procedures for
#'  Agricultural Research. R package version 1.3-2.
#'  \url{https://CRAN.R-project.org/package=agricolae}
#'
#' @examples
#' library(geneticae)
#' data(plrv)
#' str(plrv)
#'
NULL

#' Winter wheat varieties from Ontario
#'
#' @description Yield (t/ha) of 18 winter wheat varieties grown at 9
#'   environments in Ontario in 1993.
#'
#' @name yan.winterwheat
#' @docType data
#' @usage data(yan.winterwheat)
#'
#' @format Data frame with 162 observations and 3 variables (genotype,
#'   environment and yield)
#'
#' @keywords datasets
#' @references Kevin Wright (2018). agridat: Agricultural Datasets. R package
#'   version 1.16.\url{https://CRAN.R-project.org/package=agridat}
#'
#' @examples
#' library(geneticae)
#' data(yan.winterwheat)
#' str(yan.winterwheat)
NULL
