% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sex_to_int.R
\name{sex_to_int}
\alias{sex_to_int}
\title{Convert character sex codes to integer codes}
\usage{
sex_to_int(sex)
}
\arguments{
\item{sex}{Character vector of sex codes}
}
\value{
The converged numeric vector of sex codes
}
\description{
This function accepts the character sex codes accepted by eigenstrat and turns them into the integer codes accepted by plink.
Matching is case insensitive.
The correspondence is:
\describe{
\item{U:}{ 0 (unknown) }
\item{M:}{ 1 (male) }
\item{F:}{ 2 (female) }
}
Any other characters will also be mapped to 0 (unknown) but with a warning (U does not generate warnings).
}
\examples{
# verify the mapping above
sex_char <- c('U', 'm', 'f') # mixed case works!
sex_int <- 0:2 # expected values
stopifnot(
  all(
    sex_to_int( sex_char ) == sex_int
  )
)

}
\seealso{
\code{\link{sex_to_char}}

Eigenstrat IND format reference:
\url{https://github.com/DReichLab/EIG/tree/master/CONVERTF}

Plink FAM format reference:
\url{https://www.cog-genomics.org/plink/1.9/formats#fam}
}
