% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_plots.R
\name{bar_impvar}
\alias{bar_impvar}
\title{Bar Plot of a ranking of categorical variables by importance}
\usage{
bar_impvar(x, cex.names = 1, cex.axis = 1.2, cex.main = 1, ...)
}
\arguments{
\item{x}{An object of the class \code{"plstree"}}

\item{cex.names}{Expansion factor for axis names (bar labels)}

\item{cex.axis}{Expansion factor for numeric axis labels}

\item{cex.main}{Allows fixing the size of the main. Equal to 1 to default}

\item{\dots}{Further arguments are ignored}
}
\description{
\code{"bar_impvar"} returns a bar plot to  visualize the ranking
of variables by importance  in obtaining the terminal nodes of Pathmox.
}
\details{
The importance of each variable is determined by adding the F-statistic 
calculated for the variable in each split node of Pathmox.
}
\examples{
 \dontrun{
# Example of PATHMOX approach in customer satisfaction analysis 
# (Spanish financial company).
# Model with 5 LVs (4 reflective: Image (IMAG), Value (VAL), 
# Satisfaction (SAT), and Loyalty (LOY); and 1 formative construct: 
# Quality (QUAL))

# load library and dataset csibank
library(genpathmx)
data("csibank")

# Define the model using the lavaan syntax. Use a set of regression formulas to define
# first the structural model and then the measurement model

CSImodel <- "
# Structural model
VAL  ~ QUAL
SAT  ~ IMAG  + QUAL + VAL
LOY  ~ IMAG + SAT

# Measurement model
# Formative
QUAL <~ qual1 + qual2 + qual3 + qual4 + qual5 + qual6 + qual7 
     
# Reflective
IMAG <~ imag1 + imag2 + imag3 + imag4 + imag5 + imag6 
VAL  <~ val1  + val2  + val3  + val4
SAT  =~ sat1  + sat2  + sat3           
LOY  =~ loy1  + loy2  + loy3          

"

# Check if variables are well specified (they have to be factors 
# and/or ordered factors)
str(CSIcatvar)

# Transform age and education into ordered factors
CSIcatvar$Age = factor(CSIcatvar$Age, levels=c("<=25", 
                                     "26-35", "36-45", "46-55", 
                                     "56-65", ">=66"),ordered=T)

CSIcatvar$Education = factor(CSIcatvar$Education, 
                            levels=c("Unfinished","Elementary", "Highschool",
                            "Undergrad", "Graduated"),ordered=T)
       
# Run Pathmox analysis (Lamberti et al., 2016; 2017)
csi.pathmox = pls.pathmox(
 .model = CSImodel ,
 .data  = csibank,
 .catvar= CSIcatvar,
 .signif = 0.05,
 .deep=2
)                     
 
bar_impvar(csi.pathmox)

}

}
\references{
Lamberti, G. et al. (2016). The Pathmox approach for PLS path modeling 
segmentation. \emph{Applied Stochastic Models in Business and Industry}, 
doi: 10.1002/asmb.2168.

Lamberti, G. (2015). \emph{Modeling with Heterogeneity}, PhD Dissertation.
}
\seealso{
\code{\link{summary.plstree}}, \code{\link{print.plstree}}, \code{\link{pls.pathmox}},  
\code{\link{bar_terminal}}, and \code{\link{plot.plstree}}
}
\author{
Giuseppe Lamberti
}
