% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selpropdist.R
\name{select_proposals}
\alias{select_proposals}
\alias{select_proposals_SEQ}
\alias{select_proposals_MNX}
\alias{select_proposals_ENT}
\title{Selection of multiple importance sampling distributions}
\usage{
select_proposals_SEQ(
  pargrid,
  K,
  istart,
  relativeSE = FALSE,
  N1,
  N2,
  Nthin,
  Nbi,
  formula,
  family = "gaussian",
  data,
  weights,
  subset,
  offset,
  atsample,
  corrfcn = "matern",
  betm0,
  betQ0,
  ssqdf,
  ssqsc,
  dispersion = 1,
  longlat = FALSE,
  nbatch1 = 0.5,
  nbatch2 = 0.5,
  S1method = c("RL", "MW"),
  bvmethod = c("Standard", "TukeyHanning", "Bartlett"),
  transf = c("no", "mu", "wo")
)

select_proposals_MNX(
  pargrid,
  istart,
  nfix,
  relativeSE = FALSE,
  N1,
  N2,
  Nthin,
  Nbi,
  cooling,
  formula,
  family = "gaussian",
  data,
  weights,
  subset,
  offset,
  atsample,
  corrfcn = "matern",
  betm0,
  betQ0,
  ssqdf,
  ssqsc,
  dispersion = 1,
  longlat = FALSE,
  nbatch1 = 0.5,
  nbatch2 = 0.5,
  S1method = c("RL", "MW"),
  bvmethod = c("Standard", "TukeyHanning", "Bartlett"),
  transf = c("no", "mu", "wo"),
  verbose = FALSE
)

select_proposals_ENT(
  pargrid,
  istart,
  nfix,
  relativeSE = FALSE,
  N1,
  Nthin,
  Nbi,
  cooling,
  formula,
  family = "gaussian",
  data,
  weights,
  subset,
  offset,
  atsample,
  corrfcn = "matern",
  betm0,
  betQ0,
  ssqdf,
  ssqsc,
  dispersion = 1,
  longlat = FALSE,
  nbatch1 = 0.5,
  nbatch2 = 0.5,
  S1method = c("RL", "MW"),
  bvmethod = c("Standard", "TukeyHanning", "Bartlett"),
  transf = c("no", "mu", "wo"),
  verbose = FALSE
)
}
\arguments{
\item{pargrid}{A data frame with components "linkp", "phi", "omg",
"kappa". Each row gives a combination of the parameters to
compute the new standard errors.}

\item{K}{How many proposal densities in total to choose among the
rows of \code{pargrid}. Needed for SEQ only. For MNX and ENT
this is determined by the length of \code{istart}.}

\item{istart}{Start with these rows of \code{pargrid}. A vector of
indices.}

\item{relativeSE}{Logical. Whether the choice is based on the
standard error (FALSE), or relative standard error (TRUE).}

\item{N1}{The sample size for stage 1.}

\item{N2}{The sample sie for stage 2.}

\item{Nthin}{Thinning}

\item{Nbi}{Burn-in}

\item{formula}{A representation of the model in the form
\code{response ~ terms}. The response must be set to \code{NA}'s
at the prediction locations (see the examples on how to do this
using the function \code{\link{stackdata}}). At the observed
locations the response is assumed to be a total of replicated
measurements. The number of replications is inputted using the
argument \code{weights}.}

\item{family}{The distribution of the data. The
\code{"GEVbinomial"} family is the binomial family with link the
GEV link (see Details).}

\item{data}{An optional data frame containing the variables in the
model.}

\item{weights}{An optional vector of weights. Number of replicated
samples for Gaussian and gamma, number of trials for binomial,
time length for Poisson.}

\item{subset}{An optional vector specifying a subset of
observations to be used in the fitting process.}

\item{offset}{See \code{\link[stats]{lm}}.}

\item{atsample}{A formula in the form \code{~ x1 + x2 + ... + xd}
with the coordinates of the sampled locations.}

\item{corrfcn}{Spatial correlation function. See
\code{\link{geoBayes_correlation}} for details.}

\item{betm0}{Prior mean for beta (a vector or scalar).}

\item{betQ0}{Prior standardised precision (inverse variance)
matrix. Can be a scalar, vector or matrix. The first two imply a
diagonal with those elements. Set this to 0 to indicate a flat
improper prior.}

\item{ssqdf}{Degrees of freedom for the scaled inverse chi-square
prior for the partial sill parameter.}

\item{ssqsc}{Scale for the scaled inverse chi-square prior for the
partial sill parameter.}

\item{dispersion}{The fixed dispersion parameter.}

\item{longlat}{How to compute the distance between locations. If
\code{FALSE}, Euclidean distance, if \code{TRUE} Great Circle
distance. See \code{\link[sp]{spDists}}.}

\item{nbatch1}{A scalar or vector of the same length as
\code{runs}. All values must be integers or less than 1. This is
used for calculating how many batches to split each of the
sample in runs for the calculation of the Bayes factors standard
errors for the parameters corresponding to \code{runs}.}

\item{nbatch2}{A scalar or vector of the same length as
\code{runs}. All values must be integers or less than 1. This is
used for calculating how many batches to split each of the
sample in runs for the calculation of the Bayes factors standard
errors for the parameters corresponding to \code{pargrid}.}

\item{S1method}{Which method to use to calculate the Bayes
factors: Reverse logistic or Meng-Wong.}

\item{bvmethod}{Which method to use for the calculation of the
batch variance. The standard method splits to disjoint batches.
The second and third method use the spectral variance method
with different lag windows.}

\item{transf}{Whether to use a transformed sample for the
computations. If \code{"no"} or \code{FALSE}, it doesn't. If
\code{"mu"} or \code{TRUE}, it uses the samples for the mean. If
\code{"wo"} it uses an alternative transformation. The latter
can be used only for the families indicated by
\code{.geoBayes_models$haswo}.}

\item{nfix}{In the case of MNX and ENT, the first \code{nfix}
elements of \code{istart} will always be included.}

\item{cooling}{A decreasing sequence of temperature values for the
simulated annealing. All elements must be positive. A suggested
value is \code{Tinit / log(((0:N) \%/\% Tstp)*Tstp + exp(1))} for
\code{N+1} iterations, where \code{Tinit} is the initial
temperature and \code{Tstp} is the number of iterations before
the temperature is reduced.}

\item{verbose}{Logical. Prints information about the simulated
annealing.}
}
\value{
A list with components
\describe{
\item{selected}{The rows of \code{pargrid} selected.}
\item{isel}{The indices of the rows of \code{pargrid} selected.}
\item{se}{The standard error corresponding to the selected
  parameters.}
\item{samples}{A list containing the samples from the selected
  parameters.} 
}
}
\description{
Selection of multiple importance sampling distributions
}
\details{
\describe{
\item{SEQ}{is a sequential method starting with \code{istart} and
additng to it until \code{K} proposals have been selected. At each
iteration, the point with the highest (relative?) standard error
is added} 
\item{MNX}{is the minimax method. The chosen proposal corresponds
to the lowest maximum (relative?) standard error.}
\item{ENT}{is the entropy method. The chosen proposal corresponds
to the highest determinant of the (relative?) covariance matrix at
the first stage.}
}
}
\examples{
\dontrun{
data(rhizoctonia)
### Define the model
corrf <- "spherical"
kappa <- 0
ssqdf <- 1
ssqsc <- 1
betm0 <- 0
betQ0 <- .01
family <- "binomial.probit"
formula <- Infected ~ 1
atsample <- ~ Xcoord + Ycoord
### Skeleton points
philist <- seq(100, 200, 10)
omglist <- 0
parlist <- expand.grid(linkp=0, phi=philist, omg=omglist, kappa = kappa)
### MCMC sizes
Nout <- 100
Nthin <- 1
Nbi <- 10
## Select proposals
K <- 3                        # Choose 3 proposals
istart_SEQ <- 6               # Start with middle
istart_MNX <- istart_ENT <- c(6, 2, 10)
cooling_MNX <- .05/log((0:24 \%/\% 5)*5 + exp(1))
cooling_ENT <- .3/log((0:49 \%/\% 10)*10 + exp(1))
prop_SEQ <- select_proposals_SEQ(pargrid = parlist, K = K,
                                 istart = istart_SEQ,
                                 relativeSE = TRUE, 
                                 N1 = Nout, N2 = Nout,
                                 Nthin = Nthin, Nbi = Nbi,
                                 formula = formula, family = family,
                                 data = rhizoctonia, weights = Total, 
                                 atsample = atsample, corrfcn = corrf,
                                 betm0 = betm0, betQ0 = betQ0,
                                 ssqdf = ssqdf, ssqsc = ssqsc,
                                 dispersion = 1, longlat = FALSE,
                                 nbatch1 = 0.5, nbatch2 = 0.5,
                                 bvmethod = "TukeyHanning",
                                 transf = "mu")
prop_MNX <- select_proposals_MNX(pargrid = parlist,
                                 istart = istart_MNX, nfix = 1L,
                                 cooling = cooling_MNX, 
                                 relativeSE = TRUE, 
                                 N1 = Nout, N2 = Nout,
                                 Nthin = Nthin, Nbi = Nbi,
                                 formula = formula, family = family,
                                 data = rhizoctonia, weights = Total, 
                                 atsample = atsample, corrfcn = corrf,
                                 betm0 = betm0, betQ0 = betQ0,
                                 ssqdf = ssqdf, ssqsc = ssqsc,
                                 dispersion = 1, longlat = FALSE,
                                 nbatch1 = 0.5, nbatch2 = 0.5,
                                 bvmethod = "TukeyHanning",
                                 transf = "mu",
                                 verbose = TRUE)
prop_ENT <- select_proposals_ENT(pargrid = parlist,
                                 istart = istart_ENT, nfix = 1L,
                                 cooling = cooling_ENT, 
                                 relativeSE = TRUE, 
                                 N1 = Nout, 
                                 Nthin = Nthin, Nbi = Nbi,
                                 formula = formula, family = family,
                                 data = rhizoctonia, weights = Total, 
                                 atsample = atsample, corrfcn = corrf,
                                 betm0 = betm0, betQ0 = betQ0,
                                 ssqdf = ssqdf, ssqsc = ssqsc,
                                 dispersion = 1, longlat = FALSE,
                                 nbatch1 = 0.5, nbatch2 = 0.5,
                                 bvmethod = "TukeyHanning",
                                 transf = "mu",
                                 verbose = TRUE)
}
}
\references{
Roy, V., & Evangelou, E. (2018). Selection of proposal
  distributions for generalized importance sampling estimators.
  arXiv preprint arXiv:1805.00829.
}
