% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-Methods.R
\docType{methods}
\name{spc.plot.plotly}
\alias{spc.plot.plotly}
\alias{spc.plot.plotly,Spectra-method}
\title{Plot a Spectra object data}
\usage{
spc.plot.plotly(sp, plot.max = 10, showlegend = FALSE,
  legend_field = "row", hoverinfo = "title", title = sp@LongName)

\S4method{spc.plot.plotly}{Spectra}(sp, plot.max = 10, showlegend = FALSE,
  legend_field = "row", hoverinfo = "title", title = sp@LongName)
}
\arguments{
\item{sp}{A \code{Spectra} object}

\item{plot.max}{numeric value for a maximum number of data in plot. Default is 10.}

\item{showlegend}{logical, to display legend or not, default is FALSE}

\item{legend_field}{character. Gives the name of the column to be used in the legend.}

\item{hoverinfo}{a chracter, info about  \code{Spectra} object to be used  in hover box.}

\item{title}{a chracter string, title for plot.}
}
\description{
Plot a \code{Spectra} object with plotly engine
}
\examples{
sp = spc.example_spectra()
spc.plot.plotly(sp)
spc.plot.plotly(sp,legend_field = "Spectra")
spc.plot.plotly(sp,legend_field = "CAST")
spc.plot.plotly(sp,legend_field = "NISKIN")
spc.plot.plotly(sp,legend_field = "STATION")
spc.plot.plotly(sp,legend_field = "anap_440")

}
