% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpcList-Methods.R
\name{$,SpcList-method}
\alias{$,SpcList-method}
\title{Extract or replace parts of a \code{SpcList} object}
\usage{
\S4method{$}{SpcList}(x, name)
}
\arguments{
\item{x}{A \code{Spectra} object from which to extract element(s) or in which to replace element(s)}

\item{name}{A character (column name)}
}
\description{
Operators acting on  \code{Spectra} objects  to extract or replace parts
}
\examples{
  sp<-spc.example_spectra()
  BL = spc.makeSpcList(sp,"STATION")
  
  #Extract station 394 (returns Spectra object)
  BL$`394`
  
  BL@by="CRUISE"
  BL[[1]]$CRUISE="Cruise1"
  BL[[2]]$CRUISE="Cruise2"
  BL[[3]]$CRUISE="Cruise3"
  BL[[4]]$CRUISE="Cruise4"
  names(BL)
  BL$Cruise4

}
