% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cate.R
\name{get_cate}
\alias{get_cate}
\title{Generate a Hajek estimator for heterogeneity analysis}
\usage{
get_cate(
  obs,
  cf1,
  cf2,
  treat,
  pixel_count_out,
  lag,
  trunc_level = 0.95,
  time_after = TRUE,
  entire_window = NULL,
  em = NULL,
  E_mat = NULL,
  nbase = 6,
  spline_type = "ns",
  intercept = TRUE,
  eval_values = NULL,
  eval_mat = NULL,
  test_beta = NULL,
  bound = 1,
  save_weights = TRUE,
  ...
)
}
\arguments{
\item{obs}{observed density}

\item{cf1}{counterfactual density 1}

\item{cf2}{counterfactual density 2}

\item{treat}{column of a hyperframe that summarizes treatment data. In the form of `hyperframe$column`.}

\item{pixel_count_out}{column of a hyperframe that summarizes the number of outcome events in each pixel}

\item{lag}{integer that specifies lags to calculate causal estimates.}

\item{trunc_level}{the level of truncation for the weights (0-1).}

\item{time_after}{whether to include one unit time difference between treatment and outcome. By default = TRUE}

\item{entire_window}{owin object (the entire region of interest)}

\item{em}{treat column of a hyperframe that summarizes the effect modifier data. In the form of `hyperframe$column`. It can be NULL if E_mat is provided.}

\item{E_mat}{optional covariance matrix (excluding the intercept) for the effect modifier. If provided, then the regression model will be based on this matrix. If `intercept = TRUE`, then a column of 1 will be add to `E_mat`.}

\item{nbase}{number of bases for splines}

\item{spline_type}{type of splines. Either `"ns"` or `"bs"`.}

\item{intercept}{whether to include intercept in the regression model. Default is TRUE.}

\item{eval_values}{a vector of values of the effect modifier for which CATE will be evaluated. Default is a `seq(a,b,length.out=20)` where `a` and `b` are minimum and maximum values of the effect modifier.}

\item{eval_mat}{evaluated spline basis (excluding the intercept) matrix at `eval_values`.  If `intercept = TRUE`, then a column of 1 will be add to `eval_mat`.}

\item{test_beta}{a vector of integers contain the indices of the coefficients that are included in the hypothesis test. By default, the null hypothesis is that all coefficient  (except the intercept is 0). See details below}

\item{bound}{either `1` or `2` specifying which bound estimator will be used. Default is `1`}

\item{save_weights}{whether to save weights. Default is `TRUE`}

\item{...}{arguments passed onto the function}
}
\value{
list of the following:
`est_beta`: estimated regression coefficient
`V_beta`: estimated asymptotic covariance matrix of regression coefficient (normalized by total time periods)   
`chisq_stat`: observed chi-square statistics for the hypothesis test
`p.value`: observed chi-square statistics for the hypothesis test
`specification`: information about the specification of the spline basis and the values on which the CATE is estimated
`est_eval`: estimated CATE evaluted at chosen values
`V_eval`: estimated asymptotic covariance matrix of the estimated CATE values (normalized by total time periods)
`mean_effect`: Mean of the pseudo pixel effect
`total_effect`: Mean of the pseudo effect for the window `entire_window`. It is equal to mean effect times the total number of pixels inside the chosen window
}
\description{
A function that returns a Hajek estimator of CATE for a spatial or spatio-temporal effect modifier
}
\details{
`E_mat` should be a matrix or array of dimensions \eqn{n} by \eqn{m} where \eqn{n} is the product of image dimensions and number of time period,
and \eqn{m} is `nbase`-`intercept`. If you want to construct your own covariate matrix `E_mat`, you should use `get_em_vec()` to convert
the effect modifer(usually a column of a hyperframe) to a vector, and then construct the splines basis based on the vector. The covariate matrix`E_mat` should not 
the column for intercept. The function `get_cate()` will conduct a hypothesis testing on whether all the selected coefficients are 0. `test_beta` is a vector of positive integers specifying the indices
of the chosen beta. The coefficients (except the intercept) are indexed by `1,2,...,nbase-intercept`. By default, it test whether all the coefficients(except the intercept) are 0, and this is testing the
the heterogeneity effect of the effect modifier.
}
