% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_auto.R
\name{grid_auto}
\alias{grid_auto}
\title{Generate a grid automatically from a country/continent name or a SpatialPolygonsDataFrame}
\usage{
grid_auto(x, names = NULL, codes = NULL, seed = NULL)
}
\arguments{
\item{x}{A country/continent name or a SpatialPolygonsDataFrame to build a grid for.}

\item{names}{An optional vector of variable names in \code{x@data} to use as "name_" columns in the resulting grid.}

\item{codes}{An optional vector of variable names in \code{x@data} to use as "code_" columns in the resulting grid.}

\item{seed}{An optional random seed sent to \code{\link[geogrid]{calculate_grid}}.}
}
\description{
Generate a grid automatically from a country/continent name or a SpatialPolygonsDataFrame
}
\details{
If a country or continent name is specified for \code{x}, it can be any of the strings found in \code{\link{auto_countries}} or \code{\link{auto_states}}. In this case, the rnaturalearth package will be searched for the corresponding shapefiles. You can use \code{\link{get_ne_data}} to see what these shapefiles look like.

The columns of the \code{@data} component of resulting shapefile (either user-specified or fetched from rnaturalearth) are those that will be available to \code{names} and \code{codes}.
}
\examples{
\dontrun{
# auto grid using a name to identify the country
grd <- grid_auto("brazil", seed = 1234)
grid_preview(grd, label = "name")
# open the result up in the grid designer for further refinement
grid_design(grd, label = "name")

# using a custom file (can be GeoJSON or shapefile)
ff <- system.file("extdata", "bay_counties.geojson", package = "geogrid")
bay_shp <- geogrid::read_polygons(ff)
grd <- grid_auto(bay_shp, seed = 1) # names are inferred
grid_preview(grd, label = "name_county")
grid_design(grd, label = "code_fipsstco")

# explicitly specify the names and codes variables to use
grd <- grid_auto(bay_shp, seed = 1, names = "county", codes = "fipsstco")
grid_preview(grd, label = "name_county")
grid_preview(grd, label = "code_fipsstco")
}
}
