% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-webprocess-obj.R
\docType{class}
\name{webprocess-class}
\alias{webprocess-class}
\title{webprocess class}
\description{
A class representing geoknife web processing specifications
}
\section{Slots}{

\describe{
\item{\code{url}}{URL for webprocessing service. 
Can be set or accessed using \code{\link[geoknife]{url}}}

\item{\code{algorithm}}{a list for algorithm used. 
Can be set or accessed using \code{\link[geoknife]{algorithm}}}

\item{\code{version}}{a character specifying the wep processing service version to use. 
Can be set or accessed using \code{\link[geoknife]{version}}}

\item{\code{email}}{an email to send finished process alert to}

\item{\code{wait}}{boolean for wait until complete (hold up R until processing is complete)}

\item{\code{sleep.time}}{numeric for time to wait in between calls to \code{\link{check}}. Only used if \code{wait=TRUE}}

\item{\code{processInputs}}{(_private) a list of required and options process inputs, and their 
default values (if specified). This is populated (or repopulated) whenever \code{algorithm} is set.}

\item{\code{WPS_SCHEMA_LOCATION}}{(_private) location for web processing service schema}

\item{\code{WPS_NAMESPACE}}{(_private) location for web processing service namespace}

\item{\code{OWS_NAMESPACE}}{(_private) namespace web location}

\item{\code{XSI_SCHEMA_LOCATION}}{(_private) schema web location}

\item{\code{XSI_NAMESPACE}}{(_private) namespace web location}

\item{\code{XLINK_NAMESPACE}}{(_private) namespace web location}

\item{\code{UTILITY_URL}}{(_private) web processing service utility url. Uses same base url as
public slot \code{url}}

\item{\code{OGC_NAMESPACE}}{(_private) namespace web location}

\item{\code{emailK}}{(_private) relative url for email when complete utility.}
}}
\seealso{
\code{\link{webprocess}}, \code{\link[geoknife]{url}}, 
\code{\link[geoknife]{algorithm}}, \code{\link[geoknife]{version}}
}

