% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOLegalConstraints.R
\docType{class}
\name{ISOLegalConstraints}
\alias{ISOLegalConstraints}
\title{ISOLegalConstraints}
\format{\code{\link{R6Class}} object.}
\usage{
ISOLegalConstraints
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO LegalConstraints
}
\description{
ISOLegalConstraints
}
\section{Fields}{

\describe{
\item{\code{accessConstraints}}{[\code{\link{ISORestriction}}] access constraint(s)}

\item{\code{useConstraints}}{[\code{\link{ISORestriction}}] use constraint(s)}

\item{\code{otherConstraints}}{[\code{\link{character}}] other constraint(s)}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOLegalConstraints}}
 }
 \item{\code{addAccessConstraint(constraint)}}{
   Adds an access constraint, as object of class "character" or class \code{\link{ISORestriction}}.
   If an object of class "character" is specified, it must match the accepted
   values given by \code{ISORestriction$values()}.
 }
 \item{\code{delAccessConstraint(constraint)}}{
   Deletes an access constraint, as object of class "character" or class \code{\link{ISORestriction}}.
   If an object of class "character" is specified, it must match the accepted
   values given by \code{ISORestriction$values()}.
 }
 \item{\code{addUseConstraint(constraint)}}{
   Adds a use constraint, as object of class "character" or class \code{\link{ISORestriction}}.
   If an object of class "character" is specified, it must match the accepted
   values given by \code{ISORestriction$values()}.
 }
 \item{\code{delUseConstraint(constraint)}}{
   Deletes a use constraint, as object of class "character" or class \code{\link{ISORestriction}}.
   If an object of class "character" is specified, it must match the accepted
   values given by \code{ISORestriction$values()}.
 }
 \item{\code{addOtherConstraint(constraint)}}{
   Adds an other constraint as object of class "character
 }
 \item{\code{delOtherConstraint(constraint)}}{
   Deletes an other constraint as object of class "character
 }
}
}

\examples{
  #create object
  md <- ISOLegalConstraints$new()
  md$addUseLimitation("limitation1")
  md$addUseLimitation("limitation2")
  md$addUseLimitation("limitation3")
  md$addAccessConstraint("copyright")
  md$addAccessConstraint("license")
  md$addUseConstraint("copyright")
  md$addUseConstraint("license")
  
  xml <- md$encode()
  
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{constraints}
\keyword{legal}
