% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRows.R
\name{getRows}
\alias{getRows}
\alias{getRows,ANY-method}
\alias{getRows,geom-method}
\alias{getRows,Raster-method}
\alias{getRows,matrix-method}
\title{Get the number of rows of a spatial object.}
\usage{
getRows(x, ...)

\S4method{getRows}{ANY}(x)

\S4method{getRows}{geom}(x)

\S4method{getRows}{Raster}(x)

\S4method{getRows}{matrix}(x)
}
\arguments{
\item{x}{the object from which to get the number of rows.}

\item{...}{other arguments.}
}
\value{
An integer of the number of rows.
}
\description{
Get the number of rows of a spatial object.
}
\examples{
getRows(x = gtGeoms$grid$continuous)

getRows(x = gtRasters$categorical)

getRows(x = matrix(0, 3, 5))
}
\seealso{
Other getters: 
\code{\link{getCRS}()},
\code{\link{getCols}()},
\code{\link{getExtent}()},
\code{\link{getFeatures}()},
\code{\link{getGroups}()},
\code{\link{getHistory}()},
\code{\link{getLayers}()},
\code{\link{getNames}()},
\code{\link{getPoints}()},
\code{\link{getRes}()},
\code{\link{getType}()},
\code{\link{getWindow}()}
}
\concept{getters}
