% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLayers.R
\name{getLayers}
\alias{getLayers}
\alias{getLayers,ANY-method}
\alias{getLayers,geom-method}
\alias{getLayers,Spatial-method}
\alias{getLayers,sf-method}
\alias{getLayers,Raster-method}
\alias{getLayers,matrix-method}
\title{Get a specific layer of a spatial object.}
\usage{
\S4method{getLayers}{ANY}(x)

\S4method{getLayers}{geom}(x)

\S4method{getLayers}{Spatial}(x)

\S4method{getLayers}{sf}(x)

\S4method{getLayers}{Raster}(x)

\S4method{getLayers}{matrix}(x)
}
\arguments{
\item{x}{the object from which to get the layer.}
}
\value{
A list of the layers of \code{x}. Each list-item hast the result of
  getNames(x) as name.
}
\description{
Get a specific layer of a spatial object.
}
\examples{
getLayers(x = gtRasters)
}
\seealso{
Other getters: 
\code{\link{getCRS}()},
\code{\link{getCols}()},
\code{\link{getExtent}()},
\code{\link{getFeatures}()},
\code{\link{getGroups}()},
\code{\link{getHistory}()},
\code{\link{getNames}()},
\code{\link{getPoints}()},
\code{\link{getRes}()},
\code{\link{getRows}()},
\code{\link{getType}()},
\code{\link{getWindow}()}
}
\concept{getters}
