% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSServiceManager.R
\docType{class}
\name{GSServiceManager}
\alias{GSServiceManager}
\title{Geoserver REST API Service Manager}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for managing GeoServer services
}
\description{
Geoserver REST API Service Manager
}
\section{Constructor}{

\describe{
 \item{\code{new(url, user, pwd, logger)}}{
   This method is used to instantiate a GSManager with the \code{url} of the
   GeoServer and credentials to authenticate (\code{user}/\code{pwd}). By default,
   the \code{logger} argument will be set to \code{NULL} (no logger). This argument
   accepts two possible values: \code{INFO}: to print only geosapi logs,
   \code{DEBUG}: to print geosapi and CURL logs
 }
 \item{\code{getServiceSettings(service, ws)}}{
   Get the service settings. To get the service settings for a specific workspace,
   specify the workspace name as \code{ws} parameter, otherwise global settings are
   retrieved.
 }
 \item{\code{getWmsSettings(ws)}}{
   Get WMS settings. To get the WMS settings for a specific workspace,
   specify the workspace name as \code{ws} parameter, otherwise global settings are
   retrieved.
 }
 \item{\code{getWfsSettings(ws)}}{
   Get WFS settings. To get the WFS settings for a specific workspace,
   specify the workspace name as \code{ws} parameter, otherwise global settings are
   retrieved.
 }
 \item{\code{getWcsSettings(ws)}}{
   Get WCS settings. To get the WCS settings for a specific workspace,
   specify the workspace name as \code{ws} parameter, otherwise global settings are
   retrieved.
 }
 \item{\code{updateServiceSettings(serviceSettings, service, ws)}}{
   Updates the service settings with an object of class \code{GSServiceSetting}.
   An optional workspace name \code{ws} can be specified to update service settings
   applying to a workspace.
 }
 \item{\code{deleteServiceSettings(service, ws)}}{
   Deletes the service settings. This method is used internally by \pkg{geosapi} 
   for disabling a service setting at workspace level.
 }
 \item{\code{updateWmsSettings(serviceSettings, ws)}}{
   Updates the WMS settings with an object of class \code{GSServiceSetting}.
   An optional workspace name \code{ws} can be specified to update WMS settings
   applying to a workspace.
 }
 \item{\code{updateWfsSettings(serviceSettings, ws)}}{
   Updates the WFS settings with an object of class \code{GSServiceSetting}.
   An optional workspace name \code{ws} can be specified to update WFS settings
   applying to a workspace.
 }
 \item{\code{updateWcsSettings(serviceSettings, ws)}}{
   Updates the WCS settings with an object of class \code{GSServiceSettings}.
   An optional workspace name \code{ws} can be specified to update WCS settings
   applying to a workspace.
 }
 \item{\code{enableWMS(ws)}}{
   Enables the WMS, either globally, or for a given workspace (optional)
 }
 \item{\code{enableWFS(ws)}}{
   Enables the WFS, either globally, or for a given workspace (optional)
 }
 \item{\code{enableWCS(ws)}}{
   Enables the WCS, either globally, or for a given workspace (optional)
 }
 \item{\code{disableServiceSettings(service, ws)}}{
   Disables a service, either globally, or for a given workspace (optional).
   For a global service setting, an UPDATE operation will be applied, while
   for a workspace service setting, a DELETE operation is applied.
 }
 \item{\code{disableWMS(ws)}}{
   Disables the WMS, either globally, or for a given workspace (optional)
 }
 \item{\code{disableWFS(ws)}}{
   Disables the WFS, either globally, or for a given workspace (optional)
 }
 \item{\code{disableWCS(ws)}}{
   Disables the WCS, either globally, or for a given workspace (optional)
 }
}
}

\examples{
\dontrun{
   GSServiceManager$new("http://localhost:8080/geoserver", "admin", "geoserver")
 }

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{geoserver}
\keyword{rest}
\keyword{service}
