% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_geouy.R
\name{load_geouy}
\alias{load_geouy}
\title{This function allows to take oficial uruguayan geometries, as object "sf", from various servers.}
\usage{
load_geouy(c, crs = 32721, folder = tempdir())
}
\arguments{
\item{c}{Define the geometries to download: may be: "Departamentos", "Secciones", "Zonas", etc. View(metadata) for details.}

\item{crs}{Define the Coordinate Reference Systems you want the output, default 32721}

\item{folder}{Folder where are the files download if formato == "zip" in metadata. Default tempdir()}
}
\value{
sf object with the requested geometries
}
\description{
This function allows to take oficial uruguayan geometries, as object "sf", from various servers.
}
\examples{
\donttest{
secc <- load_geouy(c = "Secciones")
}
}
\seealso{
Other service: 
\code{\link{add_geom}()},
\code{\link{geocode_ide_uy}()},
\code{\link{reverse_ide_uy}()},
\code{\link{tiles_geouy}()},
\code{\link{where_uy}()},
\code{\link{which_uy}()}
}
\concept{service}
\keyword{IDE}
\keyword{INE}
\keyword{MIDES}
