% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMB.R
\name{CMB}
\alias{CMB}
\title{CMB aggregation function}
\usage{
CMB(
  D,
  nsing,
  Bsing = 1,
  alpha = 1,
  singfam = Gaussian(),
  evalfam = Gaussian(),
  sing = FALSE,
  M = 10,
  m_iter = 100,
  kap = 0.1,
  LS = FALSE,
  best = 1,
  wagg,
  robagg = FALSE,
  lower = 0,
  ...
)
}
\arguments{
\item{D}{Data matrix. Has to be an \eqn{n \times (p+1)-}dimensional data frame in the format \eqn{(X,Y)}. The \eqn{X-}part must not
contain an intercept column containing only ones since this column will be added automatically.}

\item{nsing}{Number of observations (rows) used for the SingBoost submodels.}

\item{Bsing}{Number of subsamples based on which the SingBoost models are validated. Default is 1. Not to confuse with parameter \code{B} for the Stability Selection.}

\item{alpha}{Optional real number in \eqn{]0,1]}. Defines the fraction of best SingBoost models used in the aggregation step. Default is 1 (use all models).}

\item{singfam}{A SingBoost family. The SingBoost models are trained based on the corresponding loss function. Default is \code{Gaussian()} (squared loss).}

\item{evalfam}{A SingBoost family. The SingBoost models are validated according to the corresponding loss function. Default is \code{Gaussian()} (squared loss).}

\item{sing}{If \code{sing=FALSE} and the \code{singfam} family is a standard Boosting family that is contained in the package
\code{mboost}, the CMB aggregation procedure is executed for the corresponding standard Boosting models.}

\item{M}{An integer between 2 and \code{m_iter}. Indicates that in every \eqn{M-}th iteration, a singular iteration will be
performed. Default is 10.}

\item{m_iter}{Number of SingBoost iterations. Default is 100.}

\item{kap}{Learning rate (step size). Must be a real number in \eqn{]0,1]}. Default is 0.1 It is recommended to use
a value smaller than 0.5.}

\item{LS}{If a \code{singfamily} object that is already provided by \code{mboost} is used, the respective Boosting algorithm
will be performed in the singular iterations if \code{Ls} is set to \code{TRUE}. Default is \code{FALSE}.}

\item{best}{Needed in the case of localized ranking. The parameter \code{K} of the localized ranking loss will be
computed by \eqn{best \cdot n} (rounded to the next larger integer). Warning: If a parameter \code{K} is inserted into the
\code{LocRank} family, it will be ignored when executing SingBoost.}

\item{wagg}{Type of row weight aggregation. \code{'weights1'} indicates that the selection frequencies of the (best)
SingBoost models are averaged. \code{'weights2'} respects the validation losses for each model and downweights the ones
with higher validation losses.}

\item{robagg}{Optional. If setting \code{robagg=TRUE}, the best SingBoost models are ignored when executing the
aggregation to avoid inlier effects. Only reasonable in combination with \code{lower}.}

\item{lower}{Optional argument. Only reasonable when setting \code{robagg=TRUE}. \code{lower} is a real number in \eqn{[0,1[} (a rather
small number is recommended) and indicates that the aggregation ignores the SingBoost models with the best
performances to avoid possible inlier effects.}

\item{...}{Optional further arguments}
}
\value{
\item{Column measure}{Aggregated column measure as \eqn{(p+1)-}dimensional vector.}
 \item{Selected variables}{Names of the variables with positive aggregated column measure.}
 \item{Variables names}{Names of all variables including the intercept.}
 \item{Row measure}{Aggregated row measure as \eqn{n-}dimensional vector.}
}
\description{
{Aggregates the selection frequencies of multiple SingBoost models. May be used with caution since
there are not yet recommendations about good hyperparameters.}
}
\details{
{SingBoost is designed to detect variables that standard Boosting procedures may not but which may be
relevant w.r.t. the target loss function. However, one may try to stabilize this ''singular part'' of the
column measure by aggregating several SingBoost models in the sense that they are evaluated on a validation set
and that the selection frequencies are averaged, maybe in a weighted manner according to the validation losses.
Warning: This procedure does not replace a Stability Selection!}
}
\examples{
\donttest{firis<-as.formula(Sepal.Length~.)
Xiris<-model.matrix(firis,iris)
Diris<-data.frame(Xiris[,-1],iris$Sepal.Length)
colnames(Diris)[6]<-"Y"
set.seed(19931023)
cmb1<-CMB(Diris,nsing=100,Bsing=50,alpha=0.8,singfam=Rank(),
evalfam=Rank(),sing=TRUE,M=10,m_iter=100,
kap=0.1,LS=TRUE,wagg='weights1',robagg=FALSE,lower=0)
cmb1
set.seed(19931023)
cmb2<-CMB(Diris,nsing=100,Bsing=50,alpha=0.8,singfam=Rank(),
evalfam=Rank(),sing=TRUE,M=2,m_iter=100,
kap=0.1,LS=TRUE,wagg='weights1',robagg=FALSE,lower=0)
cmb2[[1]]
set.seed(19931023)
cmb3<-CMB(Diris,nsing=100,Bsing=50,alpha=0.8,singfam=Rank(),
evalfam=Rank(),sing=TRUE,M=10,m_iter=100,
kap=0.1,LS=TRUE,wagg='weights2',robagg=FALSE,lower=0)
cmb3[[1]]}
}
\references{
{Werner, T., Gradient-Free Gradient Boosting, PhD Thesis, Carl von Ossietzky University Oldenburg, 2020}
}
