% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3methods.R
\name{plot.gformula_survival}
\alias{plot.gformula_survival}
\title{Plot method for objects of class "gformula_survival"}
\usage{
\method{plot}{gformula_survival}(
  x,
  covnames = NULL,
  risk = TRUE,
  survival = FALSE,
  ncol = NULL,
  nrow = NULL,
  common.legend = TRUE,
  legend = "bottom",
  xlab = NULL,
  ylab_cov = NULL,
  ylab_risk = "risk",
  ylab_surv = "survival",
  pos_risk = NULL,
  pos_surv = NULL,
  ci_risk = FALSE,
  ...
)
}
\arguments{
\item{x}{Object of class "gformula_survival".}

\item{covnames}{Vector of character strings specifying the names of the time-varying covariates to be plotted. The ordering of covariates given here is used in the plot grid. Time-varying covariates of type \code{"categorical time"} cannot be included. To plot none of the time-varying covariates, set this argument to \code{NA}. By default, this argument is set equal to the \code{covnames} argument used in \code{\link{gformula_survival}}, where covariates of type 'categorical time' are removed.}

\item{risk}{Logical scalar indicating whether to include a plot for the risk. The default is \code{TRUE}.}

\item{survival}{Logical scalar indicating whether to include a plot for the survival. The default is \code{FALSE}.}

\item{ncol}{Number of columns in the plot grid. By default, two columns are used when there is at least two plots.}

\item{nrow}{Number of rows in the plot grid. By default, a maximum of six rows is used and additional plots are included in subsequent pages.}

\item{common.legend}{Logical scalar indicating whether to include a legend. The default is \code{TRUE}.}

\item{legend}{Character string specifying the legend position. Valid values are \code{"top"}, \code{"bottom"}, \code{"left"}, \code{"right"}, and \code{"none"}. The default is \code{"bottom"}.}

\item{xlab}{Character string for the x axes of all plots. By default, this argument is set to the \code{time_name} argument specified in \code{\link{gformula_survival}}.}

\item{ylab_cov}{Vector of character strings for the y axes of the plots for the covariates. This argument must be the same length as \code{covnames}. The i-th element of this argument corresponds to the plot for the i-th element of \code{covnames}.}

\item{ylab_risk}{Character string for the y axis of the plot for the risk (if applicable). The default is \code{"risk"}.}

\item{ylab_surv}{Character string for the y axis of the plot for the survival (if applicable). The default is \code{"survival"}.}

\item{pos_risk}{Integer specifying the position at which to order the risk plot (if applicable). By default, this argument is set to the number of plots in the grid minus one (i.e., orders the risk plot second last).}

\item{pos_surv}{Integer specifying the position at which to order the survival plot (if applicable). By default, this argument is set to the number of plots in the grid (i.e., orders the survival plot last).}

\item{ci_risk}{Logical scalar specifying whether to include error bars for the 95\% confidence intervals of the estimated risk under the natural course. This argument is only effective if the argument \code{nsamples} was set to a positive value in \code{\link{gformula_survival}}. The default is \code{TRUE}.}

\item{...}{Other arguments, which are passed to \code{\link[ggpubr]{ggarrange}}.}
}
\value{
An object of class "ggarrange". See documentation of \code{\link[ggpubr]{ggarrange}}.
}
\description{
This function generates graphs of the mean simulated vs. observed values at each time point of the
time-varying covariates, risk, and survival under the natural course. For categorical covariates,
the observed and simulated probability of each level are plotted at each time point.
}
\examples{
## Estimating the effect of static treatment strategies on risk of a
## failure event
\donttest{
id <- 'id'
time_points <- 7
time_name <- 't0'
covnames <- c('L1', 'L2', 'A')
outcome_name <- 'Y'
outcome_type <- 'survival'
covtypes <- c('binary', 'bounded normal', 'binary')
histories <- c(lagged, lagavg)
histvars <- list(c('A', 'L1', 'L2'), c('L1', 'L2'))
covparams <- list(covmodels = c(L1 ~ lag1_A + lag_cumavg1_L1 + lag_cumavg1_L2 +
                                  L3 + t0,
                                L2 ~ lag1_A + L1 + lag_cumavg1_L1 +
                                  lag_cumavg1_L2 + L3 + t0,
                                A ~ lag1_A + L1 + L2 + lag_cumavg1_L1 +
                                  lag_cumavg1_L2 + L3 + t0))
ymodel <- Y ~ A + L1 + L2 + L3 + lag1_A + lag1_L1 + lag1_L2 + t0
intervention1.A <- list(static, rep(0, time_points))
intervention2.A <- list(static, rep(1, time_points))
int_descript <- c('Never treat', 'Always treat')
nsimul <- 10000

gform_basic <- gformula(obs_data = basicdata_nocomp, id = id,
                        time_points = time_points,
                        time_name = time_name, covnames = covnames,
                        outcome_name = outcome_name,
                        outcome_type = outcome_type, covtypes = covtypes,
                        covparams = covparams, ymodel = ymodel,
                        intervention1.A = intervention1.A,
                        intervention2.A = intervention2.A,
                        int_descript = int_descript,
                        histories = histories, histvars = histvars,
                        basecovs = c('L3'), nsimul = nsimul,
                        seed = 1234)
plot(gform_basic)
}


}
\seealso{
\code{\link{gformula_survival}}
}
