% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dna_tools.R
\name{convert_base_to_number}
\alias{convert_base_to_number}
\title{Map a single base to the corresponding number (generic \code{ggDNAvis} helper)}
\usage{
convert_base_to_number(base)
}
\arguments{
\item{base}{\code{character}. A single DNA/RNA base to encode numerically (e.g. \code{"A"}).}
}
\value{
\code{integer}. The corresponding number.
}
\description{
This function takes a single base and numerically
encodes it for visualisation via \code{\link[raster:raster]{raster::raster()}}. \cr\cr
Encoding: \code{A = 1}, \code{C = 2}, \code{G = 3}, \code{T/U = 4}.
}
\examples{
convert_base_to_number("A")
convert_base_to_number("c")
convert_base_to_number("g")
convert_base_to_number("T")
convert_base_to_number("u")

}
