% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmx-plots-quantile.R
\name{pmx_qq_plot}
\alias{pmx_qq_plot}
\alias{pmx_plot_iwres_qq}
\alias{pmx_plot_eta_qq}
\alias{pmx_plot_npde_qq}
\title{Quantile-quantile plots}
\usage{
pmx_qq_plot(dname, point, is.reference_line, reference_line, is.shrink,
  shrink, is.hline, hline, filter, strat.facet, facets, strat.color, trans,
  pmxgpar, labels, axis.title, axis.text, ranges, is.smooth, smooth,
  is.band, band, is.draft, draft, is.identity_line, identity_line,
  scale_x_log10, scale_y_log10, color.scales, ...)

pmx_plot_iwres_qq(ctr, ...)

pmx_plot_eta_qq(ctr, ...)

pmx_plot_npde_qq(ctr, ...)
}
\arguments{
\item{dname}{name of dataset to be used}

\item{point}{\code{list} geom_point parameters.}

\item{is.reference_line}{\code{logical} if TRUE add reference line to the plot}

\item{reference_line}{\code{list} geom_abline parameters.}

\item{is.shrink}{\code{logical} if TRUE add shrinkage to the plot}

\item{shrink}{\code{list} shrinkage graphical parameter (geom_text)}

\item{is.hline}{\code{logical} if TRUE add horizontal line y=0 ( TRUE by default)}

\item{hline}{\code{list} geom hline graphical parameters

\strong{pmx_update parameters}}

\item{filter}{\code{expression} filter which will be applied to plotting data.}

\item{strat.facet}{\code{formula} optional stratification parameter by facetting.
This split plot by strats(each strat in a facet)}

\item{facets}{\code{list} facet_wrap parameters.}

\item{strat.color}{\code{character} optional stratification parameter by grouping.
This will split the plot by group (color) of strat.}

\item{trans}{\code{character} define the transformation to apply on x or y or both variables}

\item{pmxgpar}{an object of class pmx_gpar}

\item{labels}{\code{list} list containing plot and/or axis labels: title, subtitle, x , y}

\item{axis.title}{\code{list} containing element_text attributes to customize
the axis title. (similar to ggplot2 axis.title theme)}

\item{axis.text}{\code{list} containing element_text attributes to customize
the axis text (similar to ggplot2 axis.text theme)}

\item{ranges}{\code{list} limits of x/y ranges}

\item{is.smooth}{\code{logical} if set to TRUE add smooth layer}

\item{smooth}{\code{list} geom_smooth graphical/smoothing fun parameters}

\item{is.band}{\code{logical} if TRUE add horizontal band}

\item{band}{\code{list} horizontal band parameters. geom_hline graphical parameters.}

\item{is.draft}{\code{logical} if TRUE add draft layer}

\item{draft}{\code{list} draft layer parameters. geom_text graphical parameters.}

\item{is.identity_line}{\code{logical} if TRUE add an identity line}

\item{identity_line}{\code{list}geom_abline graphical parameters.}

\item{scale_x_log10}{\code{logical} if TRUE use log10 scale for x axis.}

\item{scale_y_log10}{\code{logical} if TRUE use log10 scale for y axis.}

\item{color.scales}{\code{list} define scales parameter in case of strat.color \code{\link{pmx_settings}}}

\item{...}{others graphics parameters passed :
\itemize{
\item \code{\link{pmx_gpar}} internal function to customize shared graphical parameters
\item \code{\link{pmx_qq}} quantile-quantile plot object.
\item \code{\link{pmx_update}} function.
}

\strong{pmx_qq parameters}}

\item{ctr}{pmx controller}
}
\value{
ggplot2 object
}
\description{
Quantile-quantile plots

Quantile-quantile plot of IWRES

Quantile-quantile plot of eta variables

Quantile-quantile plot of NPDE
}
\examples{

\donttest{
# *************** basic use ***************** ------

ctr <- theophylline()
ctr \%>\% pmx_plot_eta_qq
ctr \%>\% pmx_plot_npde_qq
ctr \%>\% pmx_plot_iwres_qq

# update graphical parameter  ----------------------

## add reference line
ctr \%>\% pmx_plot_npde_qq(reference_line=list(color="blue"))

## remove reference line
ctr \%>\% pmx_plot_eta_qq(reference_line=NULL)


# stratification  ----------------------------------

## categorical stratification color parameter
ctr \%>\% pmx_plot_iwres_qq(strat.facet="STUD",strat.color="SEX")
## categorical stratification facetting
ctr \%>\% pmx_plot_eta_qq(strat.facet = "SEX")

## do not use symmetric axis
ctr \%>\% pmx_plot_npde_qq(xmax=FALSE,reference_line=list())
}

}
\concept{qqq}
