% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_QC_FUNs.R
\name{cBar_UCL}
\alias{cBar_UCL}
\title{Upper Control Limit: Count Data (c-chart)}
\usage{
cBar_UCL(y, na.rm = FALSE, ...)
}
\arguments{
\item{y}{Vector of count data. Each observation having the
same-area of opportunity.}

\item{na.rm}{a logical value indicating whether NA values should be stripped before the computation proceeds.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A number; 3-sigma upper control limit (UCL)
}
\description{
Calculates upper control limit (UCL) for count data acquired
over the same-sized area of opportunity.
}
\examples{
set.seed(5555)
y <- rpois(30, 9)
cBar_UCL(y)

}
