#' Partial coplot data 
#' 
#'  Cached partial coplot for bilirubin and albumin interaction in pbc random forest for survival.
#' 
#' @references 
#' Ishwaran H. and Kogalur U.B. (2014). Random Forests for
#' Survival, Regression and Classification (RF-SRC), R package
#' version 1.5.4.
#' 
#' Ishwaran H. and Kogalur U.B. (2007). Random survival forests
#' for R. R News 7(2), 25-31.
#' 
#' Ishwaran H., Kogalur U.B., Blackstone E.H. and Lauer M.S.
#' (2008). Random survival forests. Ann. Appl. Statist. 2(3),
#' 841-860.
#' 
#' @examples
#' \dontrun{
#' ## Examples from randomForestSRC::rfsrc 
#' ##
#' data(pbc, package = "randomForestSRC")
#' pbc_rf <- rfsrc(Surv(days, status) ~ ., pbc, nsplit = 10)
#' 
#' # Get the training data to work with...
#' dta.train  <- pbc_rf$xvar
#' ggvar <- gg_var(pbc_rf)
#' albumin_grp <- cut(pbc_rf$xvar$albumin, breaks=c(0,seq(3,3.5,.5),5))
#' ggvar$albumin_grp <- paste("albumin=",albumin_grp, sep="")
#' dta.train$albumin_grp <- albumin_grp
#' 
#' # Create a series of coplot subsets....
#' lng <- length(levels(albumin_grp))
#' sbst <- mclapply(1:lng, function(ind){
#'   st <- which(dta.train$albumin_grp==levels(albumin_grp)[ind])
#'   if(length(st) == 0) NULL
#'   else st
#' })
#' 
#' lvl <- levels(albumin_grp)
#' # Collapse the subset list to interesting items 
#' # (those with observations)
#' # If you work backwards, you do extra tests, but it 
#' # cuts the correct items. Cute.
#' for(ind in lng:1){
#'   if(is.null(sbst[[ind]])){
#'     sbst[[ind]] <- NULL
#'     
#'     # reset the levels, so we can label things later
#'     lvl <- lvl[-ind]
#'   }
#' }
#' 
#' pDat.partlist <- mclapply(1:length(sbst), function(ind){
#'   plot.variable(pbc_rf, surv.type="surv", time=1,
#'                 subset = sbst[[ind]],
#'                 xvar.names="bili", partial=TRUE,
#'                 show.plots = FALSE)
#' })
#' 
#' gg_part <- mclapply(pDat.partlist, gg_partial)
#'
#' # Flip y-axis
#' cls <- class(gg_part)
#' class(gg_part) <-  c("gg_partial_list", cls)
#' 
#' for(ind in 1:length(gg_part)){
#'   gg_part[[ind]]$albumin <- lvl[ind]
#' }
#' pbc_prtl_bili_albumin <- do.call(rbind, gg_part)
#' pbc_prtl_bili_albumin$albumin <- paste("albumin=", pbc_prtl_bili_albumin$albumin)
#' pbc_prtl_bili_albumin$albumin <- factor(pbc_prtl_bili_albumin$albumin)
#' 
#' save(pbc_prtl_bili_albumin, file="data/pbc_prtl_bili_albumin.rda")
#' 
#' ggpl <- ggplot(gg_merge, aes(x=bili, y=yhat, shape=albumin, color=albumin))+
#'   geom_point()+geom_smooth(se=FALSE)+
#'   labs(x="Surgical Date", y="Survival 1 year")+
#'   scale_color_brewer(palette="Set1")
#' ggpl
#'  }
#' 
#' @docType data
#' @keywords datasets
#' @format A randomForestSRC::plot.variable object for survival
#' @name pbc_prtl_bili_albumin
NULL
