% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-chain-circle-genomic.R
\name{circle_genomic}
\alias{circle_genomic}
\title{Create a Circular Layout for Genomic Data}
\usage{
circle_genomic(
  data,
  ...,
  radial = NULL,
  direction = "outward",
  sector_spacing = NULL,
  theme = NULL
)
}
\arguments{
\item{data}{The input data, which can be:
\itemize{
\item A \code{character} string ("hg19" or "hg38") to load a predefined cytoband
reference.
\item A \code{data.frame} with at least three columns: \code{chromosome}, \code{start}, and
\code{end} positions.
\item A genomic object convertible via \code{\link[=fortify_data_frame]{fortify_data_frame()}}.
}}

\item{...}{Additional arguments passed to specific methods or
\code{\link[=fortify_data_frame]{fortify_data_frame()}}.}

\item{radial}{A \code{\link[=coord_circle]{coord_circle()}}/\code{\link[ggplot2:coord_radial]{coord_radial()}}
object that defines the global parameters for coordinate across all plots
in the layout. The parameters \code{start}, \code{end}, \code{direction}, and \code{expand} will
be inherited and applied uniformly to all plots within the layout. The
parameters \code{theta} and \code{r.axis.inside} will always be ignored and will be set
to \code{"x"} and \code{TRUE}, respectively, for all plots.}

\item{direction}{A single string of \code{"inward"} or \code{"outward"},
indicating the direction in which the plot is added.
\itemize{
\item \code{outward}: The plot is added from the inner to the outer.
\item \code{inward}: The plot is added from the outer to the inner.
}}

\item{sector_spacing}{The size of spacing between different panel. A numeric
of the radians or a \code{\link[ggplot2:element]{rel()}} object.}

\item{theme}{A \code{\link[ggplot2:theme]{theme()}} object used to customize various
elements of the layout, including \code{guides}, \code{title}, \code{subtitle}, \code{caption},
\code{margins}, \code{panel.border}, and \code{background}. By default, the theme will
inherit from the parent \code{layout}. It also controls the panel spacing for all
plots in the layout.}
}
\value{
A \code{circle_layout} object representing the genomic layout.
}
\description{
\code{circle_genomic()} constructs a circular layout specifically for genomic
data. It is a specialized variant of \code{circle_continuous()} that applies
default axis limits and coerces the first column of each plot's data to use
chromosome (\code{seqname}) identifiers-matching those in the layout data-as
factor levels.
}
