% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dag_labels.R
\name{DAG Labels}
\alias{DAG Labels}
\alias{label<-}
\alias{label<-.dagitty}
\alias{label<-.tidy_dagitty}
\alias{dag_label}
\alias{label}
\alias{has_labels}
\title{DAG labels}
\usage{
label(x) <- value

\method{label}{dagitty}(x) <- value

\method{label}{tidy_dagitty}(x) <- value

dag_label(.tdy_dag, labels = NULL)

label(.tdy_dag)

has_labels(.tdy_dag)
}
\arguments{
\item{x}{an object of either class \code{tidy_dagitty} or \code{dagitty}}

\item{value}{a character vector}

\item{.tdy_dag}{an object of class \code{tidy_dagitty}}

\item{labels}{a character vector}
}
\value{
\code{label} returns the label attribute of x
}
\description{
Label or otherwise retrieve labels from objects of either class
\code{tidy_dagitty} or \code{dagitty}
}
\examples{
labelled_dag <- dagify(y ~ z, x ~ z) \%>\%
  tidy_dagitty() \%>\%
  dag_label(labels = c("x" = "exposure", "y" = "outcome", "z" = "confounder"))

has_labels(labelled_dag)
}
