% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exogenous.R
\name{Exogenous Variables}
\alias{Exogenous Variables}
\alias{node_exogenous}
\alias{ggdag_exogenous}
\title{Find Exogenous Variables}
\usage{
node_exogenous(.dag, ...)

ggdag_exogenous(
  .tdy_dag,
  ...,
  node_size = 16,
  text_size = 3.88,
  edge_type = "link_arc",
  label_size = text_size,
  text_col = "white",
  label_col = text_col,
  node = TRUE,
  stylized = FALSE,
  text = TRUE,
  use_labels = NULL
)
}
\arguments{
\item{.dag, .tdy_dag}{input graph, an object of class \code{tidy_dagitty} or
\code{dagitty}}

\item{...}{additional arguments passed to \code{tidy_dagitty()}}

\item{node_size}{size of DAG node}

\item{text_size}{size of DAG text}

\item{edge_type}{a character vector, the edge geom to use. One of:
"link_arc", which accounts for directed and bidirected edges, "link",
"arc", or "diagonal"}

\item{label_size}{size of label text}

\item{text_col}{color of DAG text}

\item{label_col}{color of label text}

\item{node}{logical. Should nodes be included in the DAG?}

\item{stylized}{logical. Should DAG nodes be stylized? If so, use
\code{geom_dag_nodes} and if not use \code{geom_dag_point}}

\item{text}{logical. Should text be included in the DAG?}

\item{use_labels}{a string. Variable to use for \code{geom_dag_repel_label()}.
Default is \code{NULL}.}
}
\value{
a \code{tidy_dagitty} with an \code{exogenous} column for
exogenous variables or a \code{ggplot}
}
\description{
\code{node_exogenous} tags exogenous variables given an exposure and
outcome. \code{ggdag_exogenous} plots all exogenous variables. See
\code{\link[dagitty:exogenousVariables]{dagitty::exogenousVariables()}} for details.
}
\examples{
dag <- dagify(y ~ x1 + x2 + x3, b ~ x1 + x2)
ggdag_exogenous(dag)
node_exogenous(dag)

}
