% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_outliers.R
\name{geom_outlier}
\alias{geom_outlier}
\title{Outliers texts}
\usage{
geom_outlier(
  mapping = NULL,
  data = NULL,
  stat = "outlier",
  geom = c("text", "label", "text_repel", "label_repel"),
  position = "identity",
  ...,
  method = c("x13", "tramoseats"),
  spec = NULL,
  frequency = NULL,
  message = TRUE,
  first_date = NULL,
  last_date = NULL,
  coefficients = FALSE,
  digits = 1,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \link[ggplot2:aes]{aes()} or
\link[ggplot2:aes_]{aes_()}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{A \code{data.frame} that contains the data used for the seasonal adjustment.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{geom}{character. The geometric to use to display the data:
\code{GeomText} (\code{geom = "text"}, the default, see \link[ggplot2:geom_text]{geom_text()});
\code{GeomLabel} (\code{geom = "label"}, see \link[ggplot2:geom_text]{geom_label()});
\code{GeomTextRepel} (\code{geom = "text_repel"}, the default, see \link[ggrepel:geom_text_repel]{geom_text_repel()});
\code{GeomLabelRepel} (\code{geom = "label_repel"}, the default, see \link[ggrepel:geom_text_repel]{geom_label_repel()}).}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \link[ggplot2:layer]{layer()}. They may be parameters of
\link[ggplot2:geom_text]{geom_text()} (if \code{geom = "text"}),
\link[ggplot2:geom_text]{geom_label()} (if \code{geom = "label"}),
\link[ggrepel:geom_text_repel]{geom_text_repel()} (if \code{geom = "text_repel"})
or \link[ggrepel:geom_text_repel]{geom_label_repel()} (if \code{geom = "label_repel"}).}

\item{method}{the method used for the seasonal adjustment. \code{"x13"} (by default) for the X-13ARIMA method and \code{"tramoseats"} for TRAMO-SEATS.}

\item{spec}{the specification used for the seasonal adjustment.
See \link[RJDemetra:x13]{x13()} or \link[RJDemetra:tramoseats]{tramoseats()}.}

\item{frequency}{the frequency of the time series. By default (\code{frequency = NULL}),
the frequency is computed automatically.}

\item{message}{a \code{boolean} indicating if a message is printed with the frequency used.}

\item{first_date}{A numeric specifying the first date from which the outliers are plotted.
By default (\code{first_date = NULL}) the outliers are plotted from the
beginning of the time series.}

\item{last_date}{A numeric specifying the first date from which the outliers are plotted.
By default (\code{first_date = NULL}) the outliers are plotted until the
end of the time series.}

\item{coefficients}{boolean indicating if the estimates coefficients are printed.
By default \code{coefficients = FALSE}.}

\item{digits}{integer indicating the number of decimal places to be used for numeric diagnostics. By default \code{digits = 1}.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them.}
}
\description{
Function to add directly to the plot the outliers used in the pre-adjustment process of the seasonal adjustment.
}
\details{
With the parameter \code{geom = "text"}, the outliers used in the pre-adjustment process of the seasonal adjustment are directly added to the plot. With \code{geom = "label"} a rectangle is drawn behind the names of the outliers, making them easier to read. The same with \code{geom = "text_repel"} or \code{geom = "label_repel"} but text labels are also repeled away from each other and away from the data points (see \link[ggrepel:geom_text_repel]{geom_label_repel()}).
}
\examples{
p_sa_ipi_fr <- ggplot(data = ipi_c_eu_df, mapping = aes(x = date, y = FR)) +
    geom_line() +
    labs(title = "Seasonal adjustment of the French industrial production index",
         x = "time", y = NULL)  +
    geom_sa(color = "red", message = FALSE)
         
# To add the outliers:
p_sa_ipi_fr + geom_outlier(geom = "label",
                    message = FALSE)


# To have a more readable plot with outliers names that repeled away from each other 
# and from the data points:
p_sa_ipi_fr + 
    geom_outlier(geom = "label_repel",
                 message = FALSE,
                 vjust = 4,
                 ylim = c(NA, 65), force = 10,
                 arrow = arrow(length = unit(0.03, "npc"),
                               type = "closed", ends = "last"))

# To only plot the outliers from a specific date (2009):
p_sa_ipi_fr + 
    geom_outlier(geom = "label_repel",
                 message = FALSE,
                 first_date = 2009,
                 vjust = 4,
                 ylim = c(NA, 65), force = 10,
                 arrow = arrow(length = unit(0.03, "npc"),
                               type = "closed", ends = "last"))
}
