% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_data_analysis.R
\name{ggsave2}
\alias{ggsave2}
\title{Save a plot as image}
\usage{
ggsave2(
  plot = ggplot2::last_plot(),
  dir = NULL,
  name = "Plot",
  xt = "png",
  dpi = 600,
  width = 21,
  height,
  scale = 1,
  replace = FALSE,
  open = rlang::is_interactive()
)
}
\arguments{
\item{plot}{The plot, created with \pkg{ggplot2}.}

\item{dir}{If saved as file, the directory in which to save the html widget.
Default to temporary directory. Set global option \code{"ggfacto.export_dir"}
with \code{link[base:options]{options}} to change default directory.}

\item{name}{The name of the file to save.}

\item{xt}{The extension name, when saving as image (interactive graph will
always be .html).}

\item{dpi}{The resolution.}

\item{width}{The width in centimeters.}

\item{height}{The height in centimeters. By default, \code{width/1.41}.}

\item{scale}{Fixed ratio between horizontal and vertical axes.}

\item{replace}{Replace file ? By default, number added to find a new name.}

\item{open}{Should the resulting file be opened at once ?}
}
\value{
Creates a file, and opens it in `RStudio` viewer, as a side effect.
}
\description{
Save a plot as image
}
