% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_fortify_ts.R
\name{autoplot.tsmodel}
\alias{autoplot.HoltWinters}
\alias{autoplot.ar}
\alias{autoplot.fGARCH}
\alias{autoplot.fracdiff}
\alias{autoplot.nnetar}
\alias{autoplot.tsmodel}
\title{Autoplot time series models (like AR, ARIMA)}
\usage{
\method{autoplot}{tsmodel}(object, data = NULL, predict = NULL,
  is.date = NULL, ts.connect = TRUE, fitted.geom = "line",
  fitted.colour = "#FF0000", fitted.size = NULL, fitted.linetype = NULL,
  fitted.alpha = NULL, fitted.fill = NULL, fitted.shape = NULL,
  predict.geom = "line", predict.colour = "#0000FF", predict.size = NULL,
  predict.linetype = NULL, predict.alpha = NULL, predict.fill = NULL,
  predict.shape = NULL, conf.int = TRUE, conf.int.colour = "#0000FF",
  conf.int.linetype = "none", conf.int.fill = "#000000",
  conf.int.alpha = 0.3, ...)
}
\arguments{
\item{object}{Time series model instance}

\item{data}{original dataset, needed for \code{stats::ar}, \code{stats::Arima}}

\item{predict}{Predicted \code{stats::ts}
If not provided, try to retrieve from current environment using variable name.}

\item{is.date}{Logical frag indicates whether the \code{stats::ts} is date or not.
If not provided, regard the input as date when the frequency is 4 or 12}

\item{ts.connect}{Logical frag indicates whether connects original time-series and predicted values}

\item{fitted.geom}{geometric string for fitted time-series}

\item{fitted.colour}{line colour for fitted time-series}

\item{fitted.size}{point size for fitted time-series}

\item{fitted.linetype}{line type for fitted time-series}

\item{fitted.alpha}{alpha for fitted time-series}

\item{fitted.fill}{fill colour for fitted time-series}

\item{fitted.shape}{point shape for fitted time-series}

\item{predict.geom}{geometric string for predicted time-series}

\item{predict.colour}{line colour for predicted time-series}

\item{predict.size}{point size for predicted time-series}

\item{predict.linetype}{line type for predicted time-series}

\item{predict.alpha}{alpha for predicted time-series}

\item{predict.fill}{fill colour for predicted time-series}

\item{predict.shape}{point shape for predicted time-series}

\item{conf.int}{Logical flag indicating whether to plot confidence intervals}

\item{conf.int.colour}{line colour for confidence intervals}

\item{conf.int.linetype}{line type for confidence intervals}

\item{conf.int.fill}{fill colour for confidence intervals}

\item{conf.int.alpha}{alpha for confidence intervals}

\item{...}{Keywords passed to \code{autoplot.ts}}
}
\value{
ggplot
}
\description{
Autoplot time series models (like AR, ARIMA)
}
\examples{
d.ar <- stats::ar(AirPassengers)
autoplot(d.ar)
autoplot(d.ar, predict = predict(d.ar, n.ahead = 5))
autoplot(stats::arima(UKgas), data = UKgas)
autoplot(forecast::arfima(AirPassengers))
autoplot(forecast::nnetar(UKgas), is.date = FALSE)

d.holt <- stats::HoltWinters(USAccDeaths)
autoplot(d.holt)
autoplot(d.holt, predict = predict(d.holt, n.ahead = 5))
autoplot(d.holt, predict = predict(d.holt, n.ahead = 5, prediction.interval = TRUE))
}

