% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_surv.R
\name{autoplot.survfit}
\alias{autoplot.survfit}
\alias{autoplot.survfit.cox}
\title{Autoplot \code{survival::survfit}}
\usage{
\method{autoplot}{survfit}(object, fun = NULL, surv.geom = "step",
  surv.colour = NULL, surv.size = NULL, surv.linetype = NULL,
  surv.alpha = NULL, surv.fill = NULL, surv.shape = NULL,
  surv.connect = TRUE, conf.int = TRUE, conf.int.colour = "#0000FF",
  conf.int.linetype = "none", conf.int.fill = "#000000",
  conf.int.alpha = 0.3, censor = TRUE, censor.colour = NULL,
  censor.size = 3, censor.alpha = NULL, censor.shape = "+",
  facets = FALSE, nrow = NULL, ncol = 1, scales = "free_y",
  xlim = c(NA, NA), ylim = c(NA, NA), log = "", main = NULL,
  xlab = NULL, ylab = NULL, asp = NULL, ...)
}
\arguments{
\item{object}{\code{survival::survfit} instance}

\item{fun}{an arbitrary function defining a transformation of the survival curve}

\item{surv.geom}{geometric string for survival curve. 'step' or line'}

\item{surv.colour}{line colour for survival curve}

\item{surv.size}{point size for survival curve}

\item{surv.linetype}{line type for survival curve}

\item{surv.alpha}{alpha for survival curve}

\item{surv.fill}{fill colour survival curve}

\item{surv.shape}{point shape survival curve}

\item{surv.connect}{logical frag indicates whether connects survival curve to the origin}

\item{conf.int}{Logical flag indicating whether to plot confidence intervals}

\item{conf.int.colour}{line colour for confidence intervals}

\item{conf.int.linetype}{line type for confidence intervals}

\item{conf.int.fill}{fill colour for confidence intervals}

\item{conf.int.alpha}{alpha for confidence intervals}

\item{censor}{Logical flag indicating whether to plot censors}

\item{censor.colour}{colour for censors}

\item{censor.size}{size for censors}

\item{censor.alpha}{alpha for censors}

\item{censor.shape}{shape for censors}

\item{facets}{Logical value to specify use facets}

\item{nrow}{Number of facet/subplot rows}

\item{ncol}{Number of facet/subplot columns}

\item{scales}{Scale value passed to \code{ggplot2}}

\item{xlim}{limits for x axis}

\item{ylim}{limits for y axis}

\item{log}{which variables to log transform ("x", "y", or "xy")}

\item{main}{character vector or expression for plot title}

\item{xlab}{character vector or expression for x axis label}

\item{ylab}{character vector or expression for y axis label}

\item{asp}{the y/x aspect ratio}

\item{...}{other arguments passed to methods}
}
\value{
ggplot
}
\description{
Autoplot \code{survival::survfit}
}
\examples{
library(survival)
autoplot(survfit(Surv(time, status) ~ sex, data = lung))
autoplot(survfit(Surv(time, status) ~ sex, data = lung), facets = TRUE)
autoplot(survfit(Surv(time, status) ~ 1, data = lung))
autoplot(survfit(Surv(time, status) ~ sex, data=lung), conf.int = FALSE, censor = FALSE)
autoplot(survfit(coxph(Surv(time, status) ~ sex, data = lung)))
}
