% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_map_interactive.R
\name{geom_map_interactive}
\alias{geom_map_interactive}
\title{Create interactive polygons from a reference map}
\usage{
geom_map_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \code{\link{interactive_parameters}}.}
}
\description{
The geometry is based on \code{\link[ggplot2]{geom_map}}.
See the documentation for those functions for more details.
}
\section{Details for geom_*_interactive functions}{

The interactive parameters can be supplied with two ways:
\itemize{
  \item As aesthetics with the mapping argument (via \code{\link[ggplot2]{aes}}).
  In this way they can be mapped to data columns and apply to a set of geometries.

  \item As plain arguments into the geom_*_interactive function (see
  \code{\link[ggplot2]{layer}}). In this way they can be set to a scalar value.
}
}

\examples{
# add interactive maps to a ggplot -------
library(ggplot2)
library(ggiraph)

crimes <- data.frame(state = tolower(rownames(USArrests)), USArrests)

# create tooltips and onclick events
states_ <- sprintf("<p>\%s</p>",
                   as.character(crimes$state) )
table_ <- paste0(
  "<table><tr><td>UrbanPop</td>",
  sprintf("<td>\%.0f</td>", crimes$UrbanPop),
  "</tr><tr>",
  "<td>Assault</td>",
  sprintf("<td>\%.0f</td>", crimes$Assault),
  "</tr></table>"
)

onclick <- sprintf(
  "window.open(\\"\%s\%s\\")",
  "http://en.wikipedia.org/wiki/",
  as.character(crimes$state)
)


crimes$labs <- paste0(states_, table_)
crimes$onclick = onclick

if (require("maps") ) {
  states_map <- map_data("state")
  gg_map <- ggplot(crimes, aes(map_id = state))
  gg_map <- gg_map + geom_map_interactive(aes(
                  fill = Murder,
                  tooltip = labs,
                  data_id = state,
                  onclick = onclick
                ),
                map = states_map) +
    expand_limits(x = states_map$long, y = states_map$lat)
  x <- girafe(ggobj = gg_map)
  if( interactive() ) print(x)
}

}
\seealso{
\code{\link{girafe}}
}
