% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_viridis_interactive.R
\name{scale_viridis_interactive}
\alias{scale_viridis_interactive}
\alias{scale_colour_viridis_d_interactive}
\alias{scale_color_viridis_d_interactive}
\alias{scale_fill_viridis_d_interactive}
\alias{scale_colour_viridis_c_interactive}
\alias{scale_color_viridis_c_interactive}
\alias{scale_fill_viridis_c_interactive}
\alias{scale_colour_viridis_b_interactive}
\alias{scale_color_viridis_b_interactive}
\alias{scale_fill_viridis_b_interactive}
\alias{scale_colour_ordinal_interactive}
\alias{scale_color_ordinal_interactive}
\alias{scale_fill_ordinal_interactive}
\title{Create interactive viridis colour scales}
\usage{
scale_colour_viridis_d_interactive(...)

scale_color_viridis_d_interactive(...)

scale_fill_viridis_d_interactive(...)

scale_colour_viridis_c_interactive(...)

scale_color_viridis_c_interactive(...)

scale_fill_viridis_c_interactive(...)

scale_colour_viridis_b_interactive(...)

scale_color_viridis_b_interactive(...)

scale_fill_viridis_b_interactive(...)

scale_colour_ordinal_interactive(...)

scale_color_ordinal_interactive(...)

scale_fill_ordinal_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \code{\link[=interactive_parameters]{interactive_parameters()}}.}
}
\value{
An interactive scale object.
}
\description{
These scales are based on
\code{\link[=scale_colour_viridis_d]{scale_colour_viridis_d()}},
\code{\link[=scale_fill_viridis_d]{scale_fill_viridis_d()}},
\code{\link[=scale_colour_viridis_c]{scale_colour_viridis_c()}},
\code{\link[=scale_fill_viridis_c]{scale_fill_viridis_c()}},
\code{\link[=scale_colour_viridis_b]{scale_colour_viridis_b()}},
\code{\link[=scale_fill_viridis_b]{scale_fill_viridis_b()}},
\code{\link[=scale_colour_ordinal]{scale_colour_ordinal()}},
\code{\link[=scale_fill_ordinal]{scale_fill_ordinal()}}.
See the documentation for those functions for more details.
}
\section{Details for scale_\emph{\emph{interactive and guide}}_interactive functions}{

For scales, the interactive parameters can be supplied as arguments in the relevant function
and they can be scalar values or vectors, depending on the number of breaks (levels) and
the type of the guide used.
The guides do not accept any interactive parameter directly, they receive them from the scales.

\itemize{
\item When guide of type \code{legend} or \code{bins} is used, it will be converted to a
\code{\link[=guide_legend_interactive]{guide_legend_interactive()}} or \code{\link[=guide_bins_interactive]{guide_bins_interactive()}} respectively,
if it's not already.

The length of each scale interactive parameter vector should match the length of the breaks.
It can also be a named vector, where each name should correspond to the same break name.
It can also be defined as function that takes the breaks as input and returns a named or
unnamed vector of values as output.

The interactive parameters here, give interactivity only to the key elements of the guide.

\item When guide of type \code{colourbar} or \code{coloursteps} is used, it will be converted to a
\code{\link[=guide_colourbar_interactive]{guide_colourbar_interactive()}} or \code{\link[=guide_coloursteps_interactive]{guide_coloursteps_interactive()}}
respectively, if it's not already.

The scale interactive parameters in this case should be scalar values and give interactivity
to the colorbar only.
}

To provide interactivity to the rest of the elements of a guide, (title, labels, background, etc),
the relevant theme elements or relevant guide arguments can be used.
The \code{guide} arguments \code{title.theme} and \code{label.theme} can be defined as
\code{element_text_interactive} (in fact, they will be converted to that if they are not
already), either directly or via the theme.
See the element_*_interactive section for more details.
}

\examples{
# add interactive viridis scale to a ggplot -------
library(ggplot2)
library(ggiraph)

set.seed(4393)
dsmall <- diamonds[sample(nrow(diamonds), 1000),]
p <- ggplot(dsmall, aes(x, y)) +
  stat_density_2d(aes(
    fill = stat(nlevel),
    tooltip = paste("nlevel:", stat(nlevel))
  ),
  geom = "interactive_polygon") +
  facet_grid(. ~ cut)

# add interactive scale, by default the guide is a colourbar
p1 <- p + scale_fill_viridis_c_interactive(data_id = "nlevel",
                                           tooltip = "nlevel")
x <- girafe(ggobj = p1)
if (interactive()) print(x)

# make it legend
p2 <- p + scale_fill_viridis_c_interactive(data_id = "nlevel",
                                           tooltip = "nlevel",
                                           guide = "legend")
x <- girafe(ggobj = p2)
if (interactive()) print(x)

# set the keys separately
p3 <- p + scale_fill_viridis_c_interactive(
  data_id = function(breaks) {
    as.character(breaks)
  },
  tooltip = function(breaks) {
    as.character(breaks)
  },
  guide = "legend"
)
x <- girafe(ggobj = p3)
if (interactive()) print(x)


# make the title and labels interactive
p4 <- p + scale_fill_viridis_c_interactive(
  data_id = function(breaks) {
    as.character(breaks)
  },
  tooltip = function(breaks) {
    as.character(breaks)
  },
  guide = "legend",
  name = label_interactive("nlevel", data_id = "nlevel",
                           tooltip = "nlevel"),
  labels = function(breaks) {
    l <- lapply(breaks, function(br) {
      label_interactive(
        as.character(br),
        data_id = as.character(br),
        onclick = paste0("alert(\"", as.character(br), "\")"),
        tooltip = as.character(br)
      )
    })
    l
  }
)
x <- girafe(ggobj = p4)
x <- girafe_options(x,
                    opts_hover_key(girafe_css("stroke:red", text="stroke:none;fill:red")))
if (interactive()) print(x)

}
\seealso{
\code{\link[=girafe]{girafe()}}

Other interactive scale: 
\code{\link{scale_alpha_interactive}()},
\code{\link{scale_colour_brewer_interactive}()},
\code{\link{scale_colour_interactive}},
\code{\link{scale_colour_steps_interactive}()},
\code{\link{scale_gradient_interactive}},
\code{\link{scale_linetype_interactive}()},
\code{\link{scale_manual_interactive}},
\code{\link{scale_shape_interactive}()},
\code{\link{scale_size_interactive}()}
}
\concept{interactive scale}
