% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-fmt-tb.R
\name{stat_fmt_tb}
\alias{stat_fmt_tb}
\title{Select and slice a tibble nested in \code{data}}
\usage{
stat_fmt_tb(
  mapping = NULL,
  data = NULL,
  geom = "table",
  tb.vars = NULL,
  tb.rows = NULL,
  digits = 3,
  position = "identity",
  table.theme = NULL,
  table.rownames = FALSE,
  table.colnames = TRUE,
  table.hjust = 0.5,
  parse = FALSE,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs to be
set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{tb.vars, tb.rows}{character or numeric vectors, optionally named, used
to select and/or rename the columns or rows in the table
returned.}

\item{digits}{integer indicating the number of significant digits to be
retained in data.}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{table.theme}{NULL, list or function A gridExtra ttheme definition, or
a constructor for a ttheme or NULL for default.}

\item{table.rownames, table.colnames}{logical flag to enable or disabling
printing of row names and column names.}

\item{table.hjust}{numeric Horizontal justification for the core and column
headings of the table.}

\item{parse}{If TRUE, the labels will be parsed into expressions and
displayed as described in \code{?plotmath}.}

\item{na.rm}{a logical indicating whether NA values should be stripped before
the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\value{
A plot layer instance. Using as output \code{data} a copy of the
  input \code{data} in which the data frames mapped to \code{label} have been
  modified.
}
\description{
\code{stat_fmt_tb} selects, reorders and/or renames columns and
  or rows of a tibble nested in \code{data}. This stat is intended to be used
  to pre-process \code{tibble} objects mapped to the \code{label} aesthetic
  before adding them to a plot with \code{geom_table}.
}
\section{Computed variables}{
 The output of sequentially applying
  \code{\link[dplyr]{slice}} with \code{tb.rows} as argument and
  \code{\link[dplyr]{select}} with \code{tb.vars} to a list variable
  list mapped to \code{label} and containing a single tibble per row
  in \code{data}.
}

\examples{
my.df <-
  tibble::tibble(
    x = c(1, 2),
    y = c(0, 4),
    group = c("A", "B"),
    tbs = list(a = tibble::tibble(Xa = 1:6, Y = rep(c("x", "y"), 3)),
               b = tibble::tibble(Xb = 1:3, Y = "x"))
  )

ggplot(my.df, aes(x, y, label = tbs)) +
  stat_fmt_tb() +
  expand_limits(x = c(0,3), y = c(-2, 6))

# Hide column names, diplay row names
ggplot(my.df, aes(x, y, label = tbs)) +
  stat_fmt_tb(table.colnames = FALSE,
              table.rownames = TRUE) +
  expand_limits(x = c(0,3), y = c(-2, 6))

# Use a theme for the table
ggplot(my.df, aes(x, y, label = tbs)) +
  stat_fmt_tb(table.theme = ttheme_gtlight) +
  expand_limits(x = c(0,3), y = c(-2, 6))

# selection and renaming by column position
ggplot(my.df, aes(x, y, label = tbs)) +
  stat_fmt_tb(tb.vars = c(value = 1, group = 2),
               tb.rows = 1:3) +
  expand_limits(x = c(0,3), y = c(-2, 6))

# selection, reordering and renaming by column position
ggplot(my.df, aes(x, y, label = tbs)) +
  stat_fmt_tb(tb.vars = c(group = 2, value = 1),
              tb.rows = 1:3) +
  expand_limits(x = c(0,3), y = c(-2, 6))

# selection and renaming, using partial matching to column name
ggplot(my.df, aes(x, y, label = tbs)) +
  stat_fmt_tb(tb.vars = c(value = "X", group = "Y"),
              tb.rows = 1:3) +
  expand_limits(x = c(0,3), y = c(-2, 6))

}
\seealso{
See \code{\link{geom_table}} for details on how tables respond
  to mapped aesthetics and table themes. For details on predefined table
  themes see \code{\link{ttheme_gtdefault}}.
}
