% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_edge_width.R
\name{scale_edge_width}
\alias{scale_edge_width}
\alias{scale_edge_width_continuous}
\alias{scale_edge_width}
\alias{scale_edge_width_discrete}
\alias{scale_edge_width_manual}
\alias{scale_edge_width_identity}
\title{Edge width scales}
\usage{
scale_edge_width_continuous(..., range = c(1, 6))

scale_edge_width(..., range = c(1, 6))

scale_edge_width_discrete(..., range = c(2, 6))

scale_edge_width_manual(..., values)

scale_edge_width_identity(..., guide = "none")
}
\arguments{
\item{...}{Other arguments passed on to \code{\link{continuous_scale}}
to control name, limits, breaks, labels and so forth.}

\item{range}{a numeric vector of length 2 that specifies the minimum and
maximum size of the plotting symbol after transformation.}

\item{values}{a set of aesthetic values to map data values to. If this
is a named vector, then the values will be matched based on the names.
If unnamed, values will be matched in order (usually alphabetical) with
the limits of the scale. Any data values that don't match will be
given \code{na.value}.}

\item{guide}{Name of guide object, or object itself.}
}
\value{
A ggproto object inheriting from \code{Scale}
}
\description{
This set of scales defines width scales for edge geoms. Of all the new edge
scales defined in ggraph, this is the only one not having an equivalent in
ggplot2. In essence it mimicks the use of size in
\code{\link[ggplot2]{geom_line}} and related. As almost all edge
representations are lines of some sort, edge_width will be used much more
often than edge_size. It is not necessary to spell out that it is an edge
scale as the geom knows if it is drawing an edge. Just write \code{width} and
not \code{edge_width} in the call to geoms.
}
\seealso{
Other scale_edge_*: \code{\link{scale_edge_alpha}},
  \code{\link{scale_edge_colour}},
  \code{\link{scale_edge_fill}},
  \code{\link{scale_edge_linetype}},
  \code{\link{scale_edge_shape}},
  \code{\link{scale_edge_size}},
  \code{\link{scale_label_size}}
}
