% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_backbone.R
\name{layout_tbl_graph_backbone}
\alias{layout_tbl_graph_backbone}
\title{Place node to emphasize group structure}
\usage{
layout_tbl_graph_backbone(graph, keep = 0.2, circular = FALSE)
}
\arguments{
\item{graph}{A tbl_graph object}

\item{keep}{The fraction of edges to use for creating the backbone}

\item{circular}{ignored}
}
\value{
A data.frame with the columns \code{x}, \code{y}, \code{circular} as
well as any information stored as node variables in the tbl_graph object.
Further an edge attribute called \code{backbone} is added giving whether the edge
was selected as backbone.
}
\description{
This layout is optimised for drawing small-world types of graphs often found
in social networks, where distinct groups are still highly connected to the
remaining graph. Typical layouts struggle with this as they attempt to
minimise the edge length of all edges equally. The backbone layout is based
on weighing edges based on how well they hold together communities. The end
result is that communities tend to stick together despite high
interconnectivity.
}
\references{
Nocaj, A., Ortmann, M., & Brandes, U. (2015). \emph{Untangling the hairballs of
multi-centered, small-world online social media networks.} Journal of Graph
Algorithms and Applications: JGAA, 19(2), 595-618.
}
\seealso{
Other layout_tbl_graph_*: \code{\link{layout_tbl_graph_auto}},
  \code{\link{layout_tbl_graph_centrality}},
  \code{\link{layout_tbl_graph_circlepack}},
  \code{\link{layout_tbl_graph_dendrogram}},
  \code{\link{layout_tbl_graph_eigen}},
  \code{\link{layout_tbl_graph_fabric}},
  \code{\link{layout_tbl_graph_focus}},
  \code{\link{layout_tbl_graph_hive}},
  \code{\link{layout_tbl_graph_igraph}},
  \code{\link{layout_tbl_graph_linear}},
  \code{\link{layout_tbl_graph_manual}},
  \code{\link{layout_tbl_graph_matrix}},
  \code{\link{layout_tbl_graph_partition}},
  \code{\link{layout_tbl_graph_pmds}},
  \code{\link{layout_tbl_graph_stress}},
  \code{\link{layout_tbl_graph_treemap}},
  \code{\link{layout_tbl_graph_unrooted}}
}
\author{
The underlying algorithm is implemented in the graphlayouts package
by David Schoch
}
\concept{layout_tbl_graph_*}
