% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_freesurfer.R
\name{read_freesurfer_stats}
\alias{read_freesurfer_stats}
\title{Read in raw FreeSurfer stats file}
\usage{
read_freesurfer_stats(path, rename = TRUE)
}
\arguments{
\item{path}{path to stats file}

\item{rename}{logical. rename headers for ggseg compatibility}
}
\value{
tibble with stats information for subjects from FreeSurfer
}
\description{
FreeSurfer atlas stats files have a format
that can be difficult to easily read in to R.
This function takes a raw stats-file from the
subjects directory and reads it in as a
data.frame.
}
\examples{
\dontrun{
subj_dir <- freesurfer::fs_subj_dir()
aseg_stats <- file.path(subj_dir, "bert/stats/aseg.stats")
read_freesurfer_stats(aseg_stats)
}
}
