% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_lines.R
\name{draw_lines}
\alias{draw_lines}
\title{Draw lines from a line CSV File (from ggsem Shiny app) on a ggplot2 object}
\usage{
draw_lines(p, lines_data, zoom_level = 1, n = 500)
}
\arguments{
\item{p}{A ggplot2 object}

\item{lines_data}{An object that stores the CSV file containing information about lines from the ggsem Shiny app.}

\item{zoom_level}{A numeric value to control the zoom level of the plot. Default is 1.}

\item{n}{Number of points to be used for interpolation (for gradient straight lines). Default is 500.}
}
\value{
A ggplot object is returned as the function's output.
}
\description{
This function adds lines onto any ggplot2 output (including your own plots not created from the ggsem Shiny app).
}
\examples{
library(ggplot2)

lines_data <- data.frame(
x_start = 2, y_start = -2, x_end = 10, y_end = -2, ctrl_x = NA, ctrl_y = NA,
type = 'Straight Line', color = '#000000', end_color = '#cc3d3d', color_type = 'Gradient',
gradient_position = 0.35, width = 1.5, alpha = 1, arrow = FALSE,
arrow_type = NA, arrow_size = NA, two_way = FALSE, lavaan = FALSE,
line_style = 'solid'
)

p <- ggplot(mtcars) + geom_point(aes(mpg, disp))

draw_lines(p, lines_data, zoom_level = 1.2, n = 400)

}
