% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter_plots.R
\name{animate_scatter}
\alias{animate_scatter}
\title{A histogram of a single variable from a single target.}
\usage{
animate_scatter(
  output,
  x_parameter,
  x_dimension,
  y_parameter,
  y_dimension,
  target = NULL,
  external_target = NULL,
  use_initial_points = TRUE,
  use_weights = TRUE,
  max_size = 1,
  alpha = 0.1,
  xlimits = NULL,
  ylimits = NULL,
  default_title = FALSE,
  view_follow = FALSE,
  shadow_mark_proportion_of_max_size = NULL,
  shadow_wake_length = NULL,
  duration = NULL,
  animate_plot = TRUE,
  save_filename = NULL,
  save_path = NULL
)
}
\arguments{
\item{output}{Output from the SMC or EnK algorithm.}

\item{x_parameter}{The parameter indexed by the x-axis.}

\item{x_dimension}{(optional) The dimension of the x-parameter we wish to histogram. (default is 1)}

\item{y_parameter}{The parameter indexed by the y-axis.}

\item{y_dimension}{(optional) The dimension of the y-parameter we wish to histogram. (default is 1)}

\item{target}{(optionaL) If specified, will fix to this target, and animate over ExternalTarget (if present in output).}

\item{external_target}{(optionaL) If specified, will fix to this external_target, and animate over Target.}

\item{use_initial_points}{(optional) If target is not specified and this argument is TRUE, will add the initial unweighted proposed points to the output to be plotted. (default is TRUE)}

\item{use_weights}{(optional) If FALSE, will ignore particle weights in the scatter plot. If TRUE, will use the particle weights. (defaults to TRUE)}

\item{max_size}{(optional) The maximum size of the points in the plot. (default=1)}

\item{alpha}{(optional) The transparency of the points in the plot. (default=0.1)}

\item{xlimits}{(optional) Input of the form c(start,end), which specifies the ends of the x-axis.}

\item{ylimits}{(optional) Input of the form c(start,end), which specifies the ends of the y-axis.}

\item{default_title}{(optional) If TRUE, will provide a default title for the figure. If FALSE, no title is used. (defaults to FALSE)}

\item{view_follow}{(optional) If TRUE, the view will follow the particles. (default FALSE)}

\item{shadow_mark_proportion_of_max_size}{(optional) If set, the animation will leave behind shadow points, of a size (and transparency) specified by this proportion. (default to not set)}

\item{shadow_wake_length}{(optional) If set, the animation will leave a shadow wake behind each point, of a duration given by this parameter (proportion of the entire animation length). (default to not set)}

\item{duration}{(optional) The duration of the animation. (defaults to producing an animation that uses 10 frames per second)}

\item{animate_plot}{(optiional) If TRUE, will return an animation. If FALSE, returns a gganim object that can be furher modified before animating. (defaults to FALSE)}

\item{save_filename}{(optional) If specified, the animation will be saved to a gif with this filename. (default is not to save)}

\item{save_path}{(optional) If specified along with save_filename, will save the gif to save_path/save_filename. (defaults to working directory)}
}
\value{
A scatter plot in a ggplot figure.
}
\description{
A histogram of a single variable from a single target.
}
