% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot-calibration-spct.R
\name{autoplot.calibration_spct}
\alias{autoplot.calibration_spct}
\alias{autoplot.calibration_mspct}
\title{Create a complete ggplot for an irradiation calibration spectrum.}
\usage{
\method{autoplot}{calibration_spct}(
  object,
  ...,
  w.band = getOption("photobiology.plot.bands", default = list(UVC(), UVB(), UVA(),
    PAR())),
  range = NULL,
  unit.out = "counts",
  pc.out = FALSE,
  label.qty = "mean",
  span = NULL,
  annotations = NULL,
  time.format = "",
  tz = "UTC",
  norm = NULL,
  text.size = 2.5,
  idfactor = NULL,
  ylim = c(NA, NA),
  object.label = deparse(substitute(object)),
  na.rm = TRUE
)

\method{autoplot}{calibration_mspct}(object, ..., range = NULL, plot.data = "as.is")
}
\arguments{
\item{object}{a calibration_spct object or a calibration_mspct object.}

\item{...}{in the case of collections of spectra, additional arguments passed
to the plot methods for individual spectra, otherwise currently ignored.}

\item{w.band}{a single waveband object or a list of waveband objects.}

\item{range}{an R object on which range() returns a vector of length 2,
with min annd max wavelengths (nm).}

\item{unit.out}{character IGNORED.}

\item{pc.out}{logical, if TRUE use percents instead of fraction of one.}

\item{label.qty}{character string giving the type of summary quantity to use
for labels, one of "mean", "total", "contribution", and "relative".}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element.}

\item{annotations}{a character vector ("summaries" is ignored).}

\item{time.format}{character Format as accepted by \code{\link[base]{strptime}}.}

\item{tz}{character Time zone to use for title and/or subtitle.}

\item{norm}{numeric normalization wavelength (nm) or character string "max"
for normalization at the wavelength of highest peak.}

\item{text.size}{numeric size of text in the plot decorations.}

\item{idfactor}{character Name of an index column in data holding a
\code{factor} with each spectrum in a long-form multispectrum object
corresponding to a distinct spectrum. If \code{idfactor=NULL} the name of
the factor is retrieved from metadata or if no metadata found, the
default "spct.idx" is tried. If \code{idfactor=NA} no aesthetic is mapped
to the spectra and the user needs to use 'ggplot2' functions to manually
map an aesthetic or use facets for the spectra.}

\item{ylim}{numeric y axis limits,}

\item{object.label}{character The name of the object being plotted.}

\item{na.rm}{logical.}

\item{plot.data}{character Data to plot. Default is "as.is" plotting
one line per spectrum. When passing "mean" or "median" as
argument all the spectra must contain data at the same wavelength values.}
}
\value{
a \code{ggplot} object.
}
\description{
These methods return a ggplot object with an annotated plot of a
calibration_spct object or of the spectra contained in a calibration_mspct
object.
}
\note{
Note that scales are expanded so as to make space for the annotations.
The object returned is a ggplot objects, and can be further manipulated.
}
\seealso{
Other autoplot methods: 
\code{\link{autoplot.cps_spct}()},
\code{\link{autoplot.filter_spct}()},
\code{\link{autoplot.object_spct}()},
\code{\link{autoplot.raw_spct}()},
\code{\link{autoplot.reflector_spct}()},
\code{\link{autoplot.response_spct}()},
\code{\link{autoplot.source_spct}()},
\code{\link{autoplot.waveband}()},
\code{\link{set_annotations_default}()}
}
\concept{autoplot methods}
\keyword{hplot}
