% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/team.R, R/team_create.R, R/team_delete.R,
%   R/team_rename.R
\name{team}
\alias{team}
\alias{team_create}
\alias{team_delete}
\alias{team_rename}
\title{Create, delete, and rename teams within an organization}
\usage{
team_create(
  org,
  team,
  prefix = "",
  suffix = "",
  privacy = c("secret", "closed")
)

team_delete(org, team, team_type = c("name", "slug"), prompt = TRUE)

team_rename(org, team, new_team, team_type = c("name", "slug"))
}
\arguments{
\item{org}{Character. Name of the GitHub organization.}

\item{team}{Character. Name of teams.}

\item{prefix}{Character. Shared prefix.}

\item{suffix}{Character. Shared suffix.}

\item{privacy}{Character. Level of privacy for team, "closed" (visible to all
members of the organization) or "secret" (only visible to organization owners
and members of a team), default is "closed"}

\item{team_type}{Character. Either "slug" if the team names are slugs or "name" if full team names are provided.}

\item{prompt}{Logical. Should the user be prompted before deleting team. Default \code{true}.}

\item{new_team}{character, new team name.}
}
\value{
All functions invisibly return a list containing
the results of the relevant GitHub API calls.
}
\description{
\itemize{
\item \code{team_create()} - create teams in a GitHub organization
\item \code{team_delete()} - delete a team from a GitHub organization.
\item \code{team_rename()} - rename an existing team
}
}
\examples{
\dontrun{
team_create("ghclass-test",c("hw1-team01","hw1-team02"))

org_teams("ghclass-test", "hw1-")

team_rename("ghclass-test", "hw1-team02", "hw1-team03")

org_teams("ghclass-test", "hw1-")

team_delete("ghclass-test", "hw1-team01", prompt = FALSE)

org_teams("ghclass-test", "hw1-")


# Cleanup
team_delete("ghclass-test", org_teams("ghclass-test", "hw1-"), prompt = FALSE)
}

}
