% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igraphintegration.R
\name{BootstrapProperty}
\alias{BootstrapProperty}
\title{BootstrapProperty computes igraph analytics function on ensemble}
\usage{
BootstrapProperty(
  graph,
  property,
  directed,
  selfloops,
  nsamples = 1000,
  xi = NULL,
  omega = NULL,
  model = NULL,
  m = NULL,
  seed = NULL,
  ...
)
}
\arguments{
\item{graph}{igraph graph}

\item{property}{igraph function that can be applied to a graph}

\item{directed}{boolean}

\item{selfloops}{boolean}

\item{nsamples}{number of samples from ensemble. defaults to 1000}

\item{xi}{matrix, default null}

\item{omega}{matrix, default null}

\item{model}{ghype model from which to extract xi and omega, default to null}

\item{m}{int, number of edges to sample from model}

\item{seed}{seed}

\item{...}{other parameters to pass to `property`}
}
\value{
vector of length nsamples
}
\description{
BootstrapProperty computes igraph analytics function on ensemble
}
\examples{
\donttest{
library(igraph)
data('adj_karate')
result <- BootstrapProperty(adj_karate, page_rank, FALSE, FALSE, nsamples=10)
}

}
