% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwreg-other-methods.R
\name{model.matrix.gkwreg}
\alias{model.matrix.gkwreg}
\title{Extract Model Matrix from GKw Regression Model}
\usage{
\method{model.matrix}{gkwreg}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"gkwreg"}.}

\item{...}{Currently not used.}
}
\value{
A design matrix.
}
\description{
Extracts the model matrix (design matrix) from a fitted Generalized Kumaraswamy
regression model object.
}
\examples{
\donttest{
data(GasolineYield)
fit <- gkwreg(yield ~ batch + temp, data = GasolineYield, family = "kw")
head(model.matrix(fit))
}

}
\seealso{
\code{\link{gkwreg}}, \code{\link{model.frame.gkwreg}}
}
\author{
Lopes, J. E.
}
