% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-gldrmFit.R
\name{predict.gldrmFit}
\alias{predict.gldrmFit}
\title{Predict method for a gldrmFit object}
\usage{
\method{predict}{gldrmFit}(object, newdata = NULL, type = c("link",
  "response", "terms", "fTilt"), se.fit = FALSE, offset = NULL, ...)
}
\arguments{
\item{object}{An "ordinalNetFit" S3 object.}

\item{newdata}{Optional data frame. If NULL, fitted values will be obtained
for the training data.}

\item{type}{The type of prediction required.  Type "link" returns the linear
predictor. Type "response" returns the fitted mean. Type "terms" returns
a matrix giving the fitted values of each term in the model formula on the
linear predictor scale. Type "fTilt" returns a matrix containing the
fitted nonparametric distribution for each observation. Each row of the matrix
corresponds to an observation in \code{newdata}, and each column corresponds
to a unique response value in the training data.}

\item{se.fit}{Logical. If TRUE, standard errors are also returned. Does not apply
for \code{type = "fTilt"}.}

\item{offset}{Optional offset vector. Only used if \code{newdata} is not NULL.}

\item{...}{Not used. Additional predict arguments.}
}
\value{
The object returned depends on \code{type}.
}
\description{
Obtains predicted probabilities, predicted class, or linear predictors.
}
