% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gldrmFit.R
\name{gldrm.control}
\alias{gldrm.control}
\title{Control arguments for \code{gldrm} algorithm}
\usage{
gldrm.control(eps = 1e-10, maxiter = 100, returnfTiltMatrix = TRUE,
  returnf0ScoreInfo = FALSE, print = FALSE, betaStart = NULL,
  f0Start = NULL)
}
\arguments{
\item{eps}{Convergence threshold. The fitting algorithm has converged when the
relative change in log-likelihood between iterations is less than \code{eps}.
A single iteration consists of a \code{beta} update followed by an \code{f0}
update.}

\item{maxiter}{Maximum number of iterations allowed.}

\item{returnfTiltMatrix}{Logical. Return nonparametric fitted probabilities for
each observation. This is a matrix with nrow equal to the number of
observations and ncol equal to the number of unique response values observed.}

\item{returnf0ScoreInfo}{Logical. If \code{TRUE}, the score and information for
\code{log(f0)} are returned as components of the "gldrm" object.}

\item{print}{Logical. If \code{TRUE}, the relative change in the log-likelihood
will be printed after each iteration.}

\item{betaStart}{Optional vector of starting values for \code{beta}. If the
call to gldrm contains a formula, the values of betaStart should correspond to
the columns of the model matrix.}

\item{f0Start}{Optional vector of starting values for \code{f0}. The length
of the vector should be the number of unique values in the response, and the
vector should correspond to these values sorted in increasing order. The starting
values will be scaled to sum to one and tilted to have mean \code{mu0}. All values
should be strictly positive.}
}
\value{
Object of S3 class "gldrmControl", which is a list of control arguments.
}
\description{
This function returns control arguments for the \code{gldrm} algorithm.
Each argument has a default value, which will be used unless a different
value is provided by the user.
}
